/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.detect;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import me.autolang.config.ConfigManager;
import me.autolang.detect.LanguageConfidence;
import me.autolang.detect.LanguageDetector;
import me.autolang.libs.lingua.api.IsoCode639_1;
import me.autolang.libs.lingua.api.LanguageDetectorBuilder;
import me.autolang.locale.Language;

public class LinguaDetector
implements LanguageDetector {
    private final ConfigManager cfg;
    private final me.autolang.libs.lingua.api.LanguageDetector detector;

    public LinguaDetector(ConfigManager cfg) {
        this.cfg = cfg;
        HashSet<me.autolang.libs.lingua.api.Language> linguaLangs = new HashSet<me.autolang.libs.lingua.api.Language>();
        try {
            for (Language pl : cfg.getLanguages()) {
                me.autolang.libs.lingua.api.Language match = LinguaDetector.fromIso(pl.getCode());
                if (match == null) continue;
                linguaLangs.add(match);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.detector = linguaLangs.isEmpty() ? LanguageDetectorBuilder.fromLanguages(me.autolang.libs.lingua.api.Language.values()).build() : LanguageDetectorBuilder.fromLanguages(linguaLangs.toArray(new me.autolang.libs.lingua.api.Language[0])).build();
    }

    @Override
    public Optional<LanguageConfidence> detectLanguage(String text) {
        if (text == null || text.isBlank()) {
            return Optional.empty();
        }
        SortedMap<me.autolang.libs.lingua.api.Language, Double> map = this.detector.computeLanguageConfidenceValues(text);
        if (map == null || map.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry best = map.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).orElse(null);
        if (best == null) {
            return Optional.empty();
        }
        String code = LinguaDetector.isoCodeOf((me.autolang.libs.lingua.api.Language)((Object)best.getKey()));
        if (code == null) {
            return Optional.empty();
        }
        Language pluginLang = this.cfg.getLanguageByCode(code);
        if (pluginLang == null) {
            return Optional.empty();
        }
        return Optional.of(new LanguageConfidence(pluginLang, Math.max(0.0, Math.min(1.0, (Double)best.getValue()))));
    }

    private static String isoCodeOf(me.autolang.libs.lingua.api.Language l) {
        String name;
        try {
            IsoCode639_1 iso = l.getIsoCode639_1();
            if (iso != null) {
                return iso.name().toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable iso) {
            // empty catch block
        }
        return switch (name = l.name().toLowerCase(Locale.ROOT)) {
            case "english" -> "en";
            case "spanish" -> "es";
            case "french" -> "fr";
            case "german" -> "de";
            case "italian" -> "it";
            case "portuguese" -> "pt";
            case "russian" -> "ru";
            case "chinese" -> "zh";
            case "japanese" -> "ja";
            case "korean" -> "ko";
            case "arabic" -> "ar";
            case "hindi" -> "hi";
            case "turkish" -> "tr";
            case "polish" -> "pl";
            case "dutch" -> "nl";
            case "swedish" -> "sv";
            case "norwegian" -> "no";
            case "finnish" -> "fi";
            case "czech" -> "cs";
            case "greek" -> "el";
            case "hebrew" -> "he";
            case "indonesian" -> "id";
            case "malay" -> "ms";
            case "thai" -> "th";
            case "vietnamese" -> "vi";
            case "romanian" -> "ro";
            case "bulgarian" -> "bg";
            case "croatian" -> "hr";
            case "serbian" -> "sr";
            case "slovak" -> "sk";
            case "slovene", "slovenian" -> "sl";
            case "ukrainian" -> "uk";
            case "welsh" -> "cy";
            case "irish" -> "ga";
            case "estonian" -> "et";
            case "latvian" -> "lv";
            case "lithuanian" -> "lt";
            case "bengali" -> "bn";
            case "urdu" -> "ur";
            case "persian" -> "fa";
            default -> null;
        };
    }

    private static me.autolang.libs.lingua.api.Language fromIso(String code) {
        if (code == null) {
            return null;
        }
        String c = code.toLowerCase(Locale.ROOT);
        for (me.autolang.libs.lingua.api.Language l : me.autolang.libs.lingua.api.Language.values()) {
            String iso = LinguaDetector.isoCodeOf(l);
            if (iso == null || !iso.equals(c)) continue;
            return l;
        }
        return null;
    }
}

