/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.libs.lingua.api.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import me.autolang.libs.lingua.api.Language;
import me.autolang.libs.lingua.internal.Ngram;
import me.autolang.libs.lingua.internal.TrainingDataLanguageModel;
import me.autolang.libs.lingua.internal.io.FilesWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007JG\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013H\u0002\u00f8\u0001\u0000J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\rH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lme/autolang/libs/lingua/api/io/LanguageModelFilesWriter;", "Lme/autolang/libs/lingua/internal/io/FilesWriter;", "()V", "createAndWriteLanguageModelFiles", "", "inputFilePath", "Ljava/nio/file/Path;", "inputFileCharset", "Ljava/nio/charset/Charset;", "outputDirectoryPath", "language", "Lme/autolang/libs/lingua/api/Language;", "charClass", "", "createLanguageModel", "Lme/autolang/libs/lingua/internal/TrainingDataLanguageModel;", "ngramLength", "", "lowerNgramAbsoluteFrequencies", "", "Lme/autolang/libs/lingua/internal/Ngram;", "writeLanguageModel", "model", "fileName", "lingua"})
public final class LanguageModelFilesWriter
extends FilesWriter {
    @NotNull
    public static final LanguageModelFilesWriter INSTANCE = new LanguageModelFilesWriter();

    private LanguageModelFilesWriter() {
    }

    @JvmStatic
    public static final void createAndWriteLanguageModelFiles(@NotNull Path inputFilePath, @NotNull Charset inputFileCharset, @NotNull Path outputDirectoryPath, @NotNull Language language, @NotNull String charClass) {
        Intrinsics.checkNotNullParameter(inputFilePath, "inputFilePath");
        Intrinsics.checkNotNullParameter(inputFileCharset, "inputFileCharset");
        Intrinsics.checkNotNullParameter(outputDirectoryPath, "outputDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)language, "language");
        Intrinsics.checkNotNullParameter(charClass, "charClass");
        INSTANCE.checkInputFilePath(inputFilePath);
        INSTANCE.checkOutputDirectoryPath(outputDirectoryPath);
        TrainingDataLanguageModel unigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 1, charClass, MapsKt.emptyMap());
        TrainingDataLanguageModel bigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 2, charClass, unigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel trigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 3, charClass, bigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel quadrigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 4, charClass, trigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel fivegramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 5, charClass, quadrigramModel.getAbsoluteFrequencies());
        INSTANCE.writeLanguageModel(unigramModel, outputDirectoryPath, "unigrams.json");
        INSTANCE.writeLanguageModel(bigramModel, outputDirectoryPath, "bigrams.json");
        INSTANCE.writeLanguageModel(trigramModel, outputDirectoryPath, "trigrams.json");
        INSTANCE.writeLanguageModel(quadrigramModel, outputDirectoryPath, "quadrigrams.json");
        INSTANCE.writeLanguageModel(fivegramModel, outputDirectoryPath, "fivegrams.json");
    }

    public static /* synthetic */ void createAndWriteLanguageModelFiles$default(Path path, Charset charset, Path path2, Language language, String string, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 0x10) != 0) {
            string = "\\p{L}";
        }
        LanguageModelFilesWriter.createAndWriteLanguageModelFiles(path, charset, path2, language, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TrainingDataLanguageModel createLanguageModel(Path inputFilePath, Charset inputFileCharset, Language language, int ngramLength, String charClass, Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
        void $this$useLines$iv;
        TrainingDataLanguageModel model = null;
        File file = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "inputFilePath.toFile()");
        Object object = file;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), inputFileCharset);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean $i$f$useLines = false;
        object2 = $this$useLines$iv;
        int n2 = 8192;
        object2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object2;
            boolean bl = false;
            Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
            boolean bl2 = false;
            model = TrainingDataLanguageModel.Companion.fromText(lines, language, ngramLength, charClass, lowerNgramAbsoluteFrequencies);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, throwable);
        }
        TrainingDataLanguageModel trainingDataLanguageModel = model;
        if (trainingDataLanguageModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("model");
            trainingDataLanguageModel = null;
        }
        return trainingDataLanguageModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeLanguageModel(TrainingDataLanguageModel model, Path outputDirectoryPath, String fileName) {
        Path modelFilePath = outputDirectoryPath.resolve(fileName);
        if (Files.isRegularFile(modelFilePath, new LinkOption[0])) {
            Files.delete(modelFilePath);
        }
        File file = modelFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "modelFilePath.toFile()");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            writer.write(model.toJson());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

