/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.libs.lingua.internal;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0011\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006/"}, d2={"Lme/autolang/libs/lingua/internal/Fraction;", "", "", "numerator", "", "denominator", "(II)V", "getDenominator", "()I", "setDenominator", "(I)V", "getNumerator", "setNumerator", "abs", "x", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "greatestCommonDenominator", "a", "b", "greatestCommonDivisor", "hashCode", "numberOfTrailingZeros", "i", "reduceToLowestTerms", "Lkotlin/Pair;", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toLong", "", "toShort", "", "toString", "", "lingua"})
public final class Fraction
extends Number
implements Comparable<Fraction> {
    private int numerator;
    private int denominator;

    public Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        Pair<Integer, Integer> pair = this.reduceToLowestTerms(this.numerator, this.denominator);
        int num = ((Number)pair.component1()).intValue();
        int den = ((Number)pair.component2()).intValue();
        this.numerator = num;
        this.denominator = den;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public final void setNumerator(int n) {
        this.numerator = n;
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final void setDenominator(int n) {
        this.denominator = n;
    }

    @Override
    public int compareTo(@NotNull Fraction other) {
        Intrinsics.checkNotNullParameter(other, "other");
        long n0d = (long)this.numerator * (long)other.denominator;
        long d0n = (long)this.denominator * (long)other.numerator;
        return n0d < d0n ? -1 : (n0d > d0n ? 1 : 0);
    }

    @NotNull
    public String toString() {
        return "" + this.numerator + '/' + this.denominator;
    }

    public byte toByte() {
        return (byte)this.doubleValue();
    }

    public char toChar() {
        return (char)this.doubleValue();
    }

    public double toDouble() {
        return (double)this.numerator / (double)this.denominator;
    }

    public float toFloat() {
        return (float)this.doubleValue();
    }

    public int toInt() {
        return (int)this.doubleValue();
    }

    public long toLong() {
        return (long)this.doubleValue();
    }

    public short toShort() {
        return (short)this.doubleValue();
    }

    private final Pair<Integer, Integer> reduceToLowestTerms(int numerator, int denominator) {
        int gcd;
        int num = numerator;
        int den = denominator;
        if (den == 0) {
            throw new ArithmeticException("zero denominator in fraction '" + num + '/' + den + '\'');
        }
        if (den < 0) {
            if (num == Integer.MIN_VALUE || den == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow in fraction " + this + ", cannot negate");
            }
            num = -num;
            den = -den;
        }
        if ((gcd = this.greatestCommonDenominator(num, den)) > 1) {
            num /= gcd;
            den /= gcd;
        }
        if (den < 0) {
            num = -num;
            den = -den;
        }
        return new Pair<Integer, Integer>(num, den);
    }

    private final int greatestCommonDenominator(int a, int b) {
        if (a == 0 || b == 0) {
            if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: greatestCommonDenominator(" + a + ", " + b + ") is 2^31");
            }
            return this.abs(a + b);
        }
        int x = a;
        int y = b;
        long xl = x;
        long yl = y;
        boolean useLong = false;
        if (x < 0) {
            if (x == Integer.MIN_VALUE) {
                useLong = true;
            } else {
                x = -x;
            }
            xl = -xl;
        }
        if (y < 0) {
            if (y == Integer.MIN_VALUE) {
                useLong = true;
            } else {
                y = -y;
            }
            yl = -yl;
        }
        if (useLong) {
            if (xl == yl) {
                throw new ArithmeticException("overflow: greatestCommonDenominator(" + a + ", " + b + ") is 2^31");
            }
            long ylyu = yl;
            yl = xl;
            if ((xl = ylyu % xl) == 0L) {
                if (yl > Integer.MAX_VALUE) {
                    throw new ArithmeticException("overflow: greatestCommonDenominator(" + a + ", " + b + ") is 2^31");
                }
                return (int)yl;
            }
            ylyu = yl;
            y = (int)xl;
            x = (int)(ylyu % xl);
        }
        return this.greatestCommonDivisor(x, y);
    }

    private final int greatestCommonDivisor(int a, int b) {
        boolean bl;
        boolean bl2 = bl = a >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = b >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int x = a;
        int y = b;
        int xTwos = this.numberOfTrailingZeros(x);
        int yTwos = this.numberOfTrailingZeros(y);
        int shift = Math.min(xTwos, yTwos);
        x >>= xTwos;
        y >>= yTwos;
        while (x != y) {
            int delta = x - y;
            y = Math.min(x, y);
            x = Math.abs(delta);
            x >>= this.numberOfTrailingZeros(x);
        }
        return x << shift;
    }

    private final int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int j = i;
        int n = 31;
        int y = j << 16;
        if (y != 0) {
            n -= 16;
            j = y;
        }
        if ((y = j << 8) != 0) {
            n -= 8;
            j = y;
        }
        if ((y = j << 4) != 0) {
            n -= 4;
            j = y;
        }
        if ((y = j << 2) != 0) {
            n -= 2;
            j = y;
        }
        return n - (j << 1 >>> 31);
    }

    private final int abs(int x) {
        int i = x >>> 31;
        return (x ^ ~i + 1) + i;
    }

    public final int component1() {
        return this.numerator;
    }

    public final int component2() {
        return this.denominator;
    }

    @NotNull
    public final Fraction copy(int numerator, int denominator) {
        return new Fraction(numerator, denominator);
    }

    public static /* synthetic */ Fraction copy$default(Fraction fraction, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = fraction.numerator;
        }
        if ((n3 & 2) != 0) {
            n2 = fraction.denominator;
        }
        return fraction.copy(n, n2);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.numerator);
        result2 = result2 * 31 + Integer.hashCode(this.denominator);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)other;
        if (this.numerator != fraction.numerator) {
            return false;
        }
        return this.denominator == fraction.denominator;
    }
}

