/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.libs.lingua.internal;

import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import me.autolang.libs.lingua.internal.Ngram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00f8\u0001\u0000J\u001c\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00f8\u0001\u0000J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lme/autolang/libs/lingua/internal/TestDataLanguageModel;", "", "ngrams", "", "Lme/autolang/libs/lingua/internal/Ngram;", "(Ljava/util/Set;)V", "getNgrams", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "lingua"})
public final class TestDataLanguageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Ngram> ngrams;
    @NotNull
    private static final Regex LETTER_REGEX = new Regex("\\p{L}+");

    public TestDataLanguageModel(@NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter(ngrams, "ngrams");
        this.ngrams = ngrams;
    }

    @NotNull
    public final Set<Ngram> getNgrams() {
        return this.ngrams;
    }

    @NotNull
    public final Set<Ngram> component1() {
        return this.ngrams;
    }

    @NotNull
    public final TestDataLanguageModel copy(@NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter(ngrams, "ngrams");
        return new TestDataLanguageModel(ngrams);
    }

    public static /* synthetic */ TestDataLanguageModel copy$default(TestDataLanguageModel testDataLanguageModel, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = testDataLanguageModel.ngrams;
        }
        return testDataLanguageModel.copy(set);
    }

    @NotNull
    public String toString() {
        return "TestDataLanguageModel(ngrams=" + this.ngrams + ')';
    }

    public int hashCode() {
        return ((Object)this.ngrams).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TestDataLanguageModel)) {
            return false;
        }
        TestDataLanguageModel testDataLanguageModel = (TestDataLanguageModel)other;
        return Intrinsics.areEqual(this.ngrams, testDataLanguageModel.ngrams);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/autolang/libs/lingua/internal/TestDataLanguageModel$Companion;", "", "()V", "LETTER_REGEX", "Lkotlin/text/Regex;", "fromText", "Lme/autolang/libs/lingua/internal/TestDataLanguageModel;", "text", "", "ngramLength", "", "lingua"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TestDataLanguageModel fromText(@NotNull String text, int ngramLength) {
            Intrinsics.checkNotNullParameter(text, "text");
            if (!(1 <= ngramLength ? ngramLength < 6 : false)) {
                boolean $i$a$-require-TestDataLanguageModel$Companion$fromText$22 = false;
                String $i$a$-require-TestDataLanguageModel$Companion$fromText$22 = "ngram length " + ngramLength + " is not in range 1..5";
                throw new IllegalArgumentException($i$a$-require-TestDataLanguageModel$Companion$fromText$22.toString());
            }
            HashSet<Ngram> ngrams = new HashSet<Ngram>();
            int i = 0;
            int n = text.length() - ngramLength;
            if (i <= n) {
                while (true) {
                    String textSlice;
                    Intrinsics.checkNotNullExpressionValue(text.substring(i, i + ngramLength), "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (LETTER_REGEX.matches(textSlice)) {
                        String ngram = Ngram.constructor-impl(textSlice);
                        ngrams.add(Ngram.box-impl(ngram));
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return new TestDataLanguageModel((Set<Ngram>)ngrams);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

