/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.libs.lingua.internal;

import com.squareup.moshi.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.autolang.libs.lingua.api.Language;
import me.autolang.libs.lingua.internal.Fraction;
import me.autolang.libs.lingua.internal.JsonLanguageModel;
import me.autolang.libs.lingua.internal.Ngram;
import me.autolang.libs.lingua.internal.TrainingDataLanguageModelKt;
import me.autolang.libs.lingua.internal.util.extension.MapExtensionsKt;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lme/autolang/libs/lingua/internal/TrainingDataLanguageModel;", "", "language", "Lme/autolang/libs/lingua/api/Language;", "absoluteFrequencies", "", "Lme/autolang/libs/lingua/internal/Ngram;", "", "relativeFrequencies", "Lme/autolang/libs/lingua/internal/Fraction;", "(Lcom/github/pemistahl/lingua/api/Language;Ljava/util/Map;Ljava/util/Map;)V", "getAbsoluteFrequencies", "()Ljava/util/Map;", "getLanguage", "()Lcom/github/pemistahl/lingua/api/Language;", "getRelativeFrequencies", "toJson", "", "Companion", "lingua"})
public final class TrainingDataLanguageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final Map<Ngram, Integer> absoluteFrequencies;
    @NotNull
    private final Map<Ngram, Fraction> relativeFrequencies;
    @NotNull
    private static final String LANGUAGE_NAME = "language";
    @NotNull
    private static final String NGRAMS_NAME = "ngrams";

    public TrainingDataLanguageModel(@NotNull Language language, @NotNull Map<Ngram, Integer> absoluteFrequencies, @NotNull Map<Ngram, Fraction> relativeFrequencies) {
        Intrinsics.checkNotNullParameter((Object)language, LANGUAGE_NAME);
        Intrinsics.checkNotNullParameter(absoluteFrequencies, "absoluteFrequencies");
        Intrinsics.checkNotNullParameter(relativeFrequencies, "relativeFrequencies");
        this.language = language;
        this.absoluteFrequencies = absoluteFrequencies;
        this.relativeFrequencies = relativeFrequencies;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final Map<Ngram, Integer> getAbsoluteFrequencies() {
        return this.absoluteFrequencies;
    }

    @NotNull
    public final Map<Ngram, Fraction> getRelativeFrequencies() {
        return this.relativeFrequencies;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toJson() {
        void $this$mapValuesTo$iv$iv;
        Object fraction;
        Map ngrams = new LinkedHashMap();
        for (Map.Entry<Ngram, Fraction> object2 : this.relativeFrequencies.entrySet()) {
            String ngram = object2.getKey().unbox-impl();
            fraction = object2.getValue();
            ngrams.computeIfAbsent(fraction, TrainingDataLanguageModel::toJson$lambda-0).add(Ngram.box-impl(ngram));
        }
        Map map = ngrams;
        Language language = this.language;
        boolean $i$f$mapValues = false;
        fraction = map;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity(map.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = CollectionsKt.joinToString$default((Iterable)it.getValue(), " ", null, null, 0, null, null, 62, null);
            map3.put(k, string);
        }
        Map map4 = destination$iv$iv;
        Language language2 = language;
        JsonLanguageModel jsonLanguageModel = new JsonLanguageModel(language2, map4);
        String string = TrainingDataLanguageModelKt.access$getJSON_ADAPTER$p().toJson(jsonLanguageModel);
        Intrinsics.checkNotNullExpressionValue(string, "JSON_ADAPTER.toJson(jsonLanguageModel)");
        return string;
    }

    private static final List toJson$lambda-0(Fraction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00f8\u0001\u0000JG\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u00072\u0006\u0010\f\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u00f8\u0001\u0000J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u0015JC\u0010\u0016\u001a\u00020\u00172\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lme/autolang/libs/lingua/internal/TrainingDataLanguageModel$Companion;", "", "()V", "LANGUAGE_NAME", "", "NGRAMS_NAME", "computeAbsoluteFrequencies", "", "Lme/autolang/libs/lingua/internal/Ngram;", "", "text", "Lkotlin/sequences/Sequence;", "ngramLength", "charClass", "computeRelativeFrequencies", "Lme/autolang/libs/lingua/internal/Fraction;", "absoluteFrequencies", "lowerNgramAbsoluteFrequencies", "fromJson", "Lit/unimi/dsi/fastutil/objects/Object2FloatMap;", "json", "Ljava/io/InputStream;", "fromText", "Lme/autolang/libs/lingua/internal/TrainingDataLanguageModel;", "language", "Lme/autolang/libs/lingua/api/Language;", "lingua"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TrainingDataLanguageModel fromText(@NotNull Sequence<String> text, @NotNull Language language, int ngramLength, @NotNull String charClass, @NotNull Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter((Object)language, TrainingDataLanguageModel.LANGUAGE_NAME);
            Intrinsics.checkNotNullParameter(charClass, "charClass");
            Intrinsics.checkNotNullParameter(lowerNgramAbsoluteFrequencies, "lowerNgramAbsoluteFrequencies");
            if (!(1 <= ngramLength ? ngramLength < 6 : false)) {
                boolean $i$a$-require-TrainingDataLanguageModel$Companion$fromText$22 = false;
                String $i$a$-require-TrainingDataLanguageModel$Companion$fromText$22 = "ngram length " + ngramLength + " is not in range 1..5";
                throw new IllegalArgumentException($i$a$-require-TrainingDataLanguageModel$Companion$fromText$22.toString());
            }
            Map<Ngram, Integer> absoluteFrequencies = this.computeAbsoluteFrequencies(text, ngramLength, charClass);
            Map<Ngram, Fraction> relativeFrequencies = this.computeRelativeFrequencies(ngramLength, absoluteFrequencies, lowerNgramAbsoluteFrequencies);
            return new TrainingDataLanguageModel(language, absoluteFrequencies, relativeFrequencies);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Object2FloatMap<String> fromJson(@NotNull InputStream json) {
            Intrinsics.checkNotNullParameter(json, "json");
            Closeable closeable = JsonReader.of(Okio.buffer(Okio.source(json)));
            Throwable throwable = null;
            try {
                JsonReader reader = (JsonReader)closeable;
                boolean bl = false;
                Object2FloatOpenHashMap<String> frequencies = new Object2FloatOpenHashMap<String>();
                reader.beginObject();
                while (reader.hasNext()) {
                    String string = reader.nextName();
                    if (Intrinsics.areEqual(string, TrainingDataLanguageModel.LANGUAGE_NAME)) {
                        reader.skipValue();
                        continue;
                    }
                    if (Intrinsics.areEqual(string, TrainingDataLanguageModel.NGRAMS_NAME)) {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            String string2 = reader.nextName();
                            Intrinsics.checkNotNullExpressionValue(string2, "reader.nextName()");
                            char[] cArray = new char[]{'/'};
                            List list = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
                            String numerator = (String)list.get(0);
                            String denominator = (String)list.get(1);
                            float frequency = Float.parseFloat(numerator) / (float)Integer.parseInt(denominator);
                            String string3 = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue(string3, "reader.nextString()");
                            Object object = new char[]{' '};
                            List ngrams = StringsKt.split$default((CharSequence)string3, object, false, 0, 6, null);
                            object = ngrams.iterator();
                            while (object.hasNext()) {
                                String ngram = (String)object.next();
                                frequencies.put(ngram, frequency);
                            }
                        }
                        reader.endObject();
                        continue;
                    }
                    throw new AssertionError((Object)"Unexpected name in language model JSON");
                }
                reader.endObject();
                frequencies.trim();
                Object2FloatMap object2FloatMap = frequencies;
                return object2FloatMap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        private final Map<Ngram, Integer> computeAbsoluteFrequencies(Sequence<String> text, int ngramLength, String charClass) {
            Map absoluteFrequencies = new LinkedHashMap();
            Regex regex = new Regex('[' + charClass + "]+");
            Iterator<String> iterator2 = text.iterator();
            block0: while (iterator2.hasNext()) {
                String lowerCasedLine;
                String line = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(line.toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
                int i = 0;
                int n = lowerCasedLine.length() - ngramLength;
                if (i > n) continue;
                while (true) {
                    String textSlice;
                    Intrinsics.checkNotNullExpressionValue(lowerCasedLine.substring(i, i + ngramLength), "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (regex.matches(textSlice)) {
                        String ngram = Ngram.constructor-impl(textSlice);
                        MapExtensionsKt.incrementCounter(absoluteFrequencies, Ngram.box-impl(ngram));
                    }
                    if (i == n) continue block0;
                    ++i;
                }
            }
            return absoluteFrequencies;
        }

        private final Map<Ngram, Fraction> computeRelativeFrequencies(int ngramLength, Map<Ngram, Integer> absoluteFrequencies, Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            Map ngramProbabilities = new LinkedHashMap();
            int totalNgramFrequency = CollectionsKt.sumOfInt((Iterable<Integer>)absoluteFrequencies.values());
            for (Map.Entry<Ngram, Integer> entry : absoluteFrequencies.entrySet()) {
                int n;
                String ngram = entry.getKey().unbox-impl();
                int frequency = ((Number)entry.getValue()).intValue();
                if (ngramLength == 1 || lowerNgramAbsoluteFrequencies.isEmpty()) {
                    n = totalNgramFrequency;
                } else {
                    String string = ngram.substring(0, ngramLength - 1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    n = ((Number)MapsKt.getValue(lowerNgramAbsoluteFrequencies, Ngram.box-impl(Ngram.constructor-impl(string)))).intValue();
                }
                int denominator = n;
                Ngram ngram2 = Ngram.box-impl(ngram);
                ngramProbabilities.put(ngram2, new Fraction(frequency, denominator));
            }
            return ngramProbabilities;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

