/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.libs.lingua.internal.io;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0004\u00a8\u0006\t"}, d2={"Lme/autolang/libs/lingua/internal/io/FilesWriter;", "", "()V", "checkInputFilePath", "", "inputFilePath", "Ljava/nio/file/Path;", "checkOutputDirectoryPath", "outputDirectoryPath", "lingua"})
public abstract class FilesWriter {
    protected final void checkInputFilePath(@NotNull Path inputFilePath) {
        Intrinsics.checkNotNullParameter(inputFilePath, "inputFilePath");
        if (!inputFilePath.isAbsolute()) {
            throw new IllegalArgumentException("Input file path '" + inputFilePath + "' is not absolute");
        }
        if (!Files.exists(inputFilePath, new LinkOption[0])) {
            throw new NoSuchFileException("Input file '" + inputFilePath + "' does not exist");
        }
        if (!Files.isRegularFile(inputFilePath, new LinkOption[0])) {
            throw new FileNotFoundException("Input file path '" + inputFilePath + "' does not represent a regular file");
        }
    }

    protected final void checkOutputDirectoryPath(@NotNull Path outputDirectoryPath) {
        Intrinsics.checkNotNullParameter(outputDirectoryPath, "outputDirectoryPath");
        if (!outputDirectoryPath.isAbsolute()) {
            throw new IllegalArgumentException("Output directory path '" + outputDirectoryPath + "' is not absolute");
        }
        if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
            throw new NotDirectoryException("Output directory '" + outputDirectoryPath + "' does not exist");
        }
        if (!Files.isDirectory(outputDirectoryPath, new LinkOption[0])) {
            throw new NotDirectoryException("Output directory path '" + outputDirectoryPath + "' does not represent a directory");
        }
    }
}

