/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.listener;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.autolang.AutoLang;
import me.autolang.api.ChatTranslatedEvent;
import me.autolang.api.PlayerLanguageDetectedEvent;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.manager.TranslationManager;
import me.autolang.storage.PlayerLanguageService;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final AutoLang plugin;
    private final ConfigManager cfg;
    private final PlayerLanguageService pls;
    private final TranslationManager manager;

    public ChatListener(AutoLang plugin, ConfigManager cfg, PlayerLanguageService pls, TranslationManager manager) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.pls = pls;
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChat(AsyncChatEvent e) {
        Player sender = e.getPlayer();
        Component originalComponent = e.message();
        String msg = PlainTextComponentSerializer.plainText().serialize(originalComponent);
        if (this.cfg.isLogMessages()) {
            this.plugin.getLogger().info("[ChatDebug] AsyncChatEvent from " + sender.getName() + ": " + msg + " (cancelled=" + e.isCancelled() + ")");
        }
        if (msg == null) {
            return;
        }
        if (msg.startsWith("!")) {
            return;
        }
        if (this.cfg.isLogMessages()) {
            this.plugin.getLogger().info("Chat from " + sender.getName() + ": " + msg);
        }
        Language senderLang = this.pls.getLanguage(sender.getUniqueId()).orElseGet(() -> this.cfg.isClientLocaleEnabled() ? this.pls.resolveFromLocale(sender.locale()).orElse(this.cfg.getDefaultLanguage()) : this.cfg.getDefaultLanguage());
        if (!this.pls.hasLanguage(sender.getUniqueId()) && this.cfg.isAutodetectEnabled() && this.pls.shouldAttemptDetection(sender.getUniqueId())) {
            this.plugin.getAsyncExecutor().execute(() -> this.plugin.getLanguageDetector().detectLanguage(msg).ifPresent(lc -> {
                if (lc.getConfidence() >= this.cfg.getAutodetectConfidenceThreshold()) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        Component line = ((TextComponent)((TextComponent)Component.text((String)("Detected language: " + lc.getLanguage().getName() + " (" + lc.getLanguage().getCode() + ") "), (TextColor)NamedTextColor.YELLOW).append(Component.text((String)"[Accept]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)("/lang set " + lc.getLanguage().getCode()))))).append((Component)Component.text((String)" "))).append(Component.text((String)"[Choose]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)"/lang")));
                        sender.sendMessage(line);
                    });
                    Bukkit.getPluginManager().callEvent((Event)new PlayerLanguageDetectedEvent(sender.getUniqueId(), lc.getLanguage(), lc.getConfidence()));
                }
            }));
        }
        HashSet<Player> recipients = new HashSet<Player>();
        for (Audience a : e.viewers()) {
            if (!(a instanceof Player)) continue;
            Player p = (Player)a;
            recipients.add(p);
        }
        recipients.add(sender);
        Map<Language, List<Player>> groups2 = this.groupByLanguage(recipients);
        Set<Language> targetLangs = groups2.keySet();
        Map translations = Collections.emptyMap();
        try {
            translations = (Map)((CompletableFuture)this.manager.translateForRecipients(msg, senderLang, targetLangs).orTimeout(this.cfg.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS).exceptionally(ex -> Collections.emptyMap())).get(this.cfg.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ChatTranslatedEvent translatedEvent = new ChatTranslatedEvent(sender, msg, translations);
        Bukkit.getPluginManager().callEvent((Event)translatedEvent);
        if (translatedEvent.isCancelled()) {
            return;
        }
        Map<Language, String> finalMap = translatedEvent.getTranslations();
        HashMap cacheLangByPlayer = new HashMap();
        ChatRenderer renderer = (source2, sourceDisplayName, message, viewer) -> {
            Language target = this.cfg.getDefaultLanguage();
            if (viewer instanceof Player) {
                Player vp = (Player)viewer;
                target = cacheLangByPlayer.computeIfAbsent(vp.getUniqueId(), id -> this.getEffectiveLanguage(vp));
            }
            String rendered = finalMap.getOrDefault(target, msg);
            return Component.text((String)("<" + source2.getName() + "> "), (TextColor)NamedTextColor.WHITE).append((Component)Component.text((String)rendered, (TextColor)NamedTextColor.WHITE));
        };
        e.renderer(renderer);
    }

    private Map<Language, List<Player>> groupByLanguage(Set<Player> players) {
        return players.stream().collect(Collectors.groupingBy(this::getEffectiveLanguage));
    }

    private String formatChat(Player sender, String message) {
        return "<" + sender.getName() + "> " + message;
    }

    private Language getEffectiveLanguage(Player p) {
        return this.pls.getLanguage(p.getUniqueId()).orElseGet(() -> this.cfg.isClientLocaleEnabled() ? this.pls.resolveFromLocale(p.locale()).orElse(this.cfg.getDefaultLanguage()) : this.cfg.getDefaultLanguage());
    }
}

