/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.autolang.AutoLang;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.storage.PlayerLanguageService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClientOptionsListener
implements Listener {
    private final AutoLang plugin;
    private final ConfigManager cfg;
    private final PlayerLanguageService pls;
    private final Map<UUID, String> lastKnownLocales = new HashMap<UUID, String>();

    public ClientOptionsListener(AutoLang plugin, ConfigManager cfg, PlayerLanguageService pls) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.pls = pls;
        if (cfg.isClientLocaleEnabled() && cfg.isClientLocaleOnChange()) {
            this.startLocaleCheckTask();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!this.cfg.isClientLocaleEnabled()) {
            return;
        }
        final Player p = e.getPlayer();
        UUID id = p.getUniqueId();
        new BukkitRunnable(){

            public void run() {
                ClientOptionsListener.this.checkAndHandleLocaleChange(p);
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    private void startLocaleCheckTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : ClientOptionsListener.this.plugin.getServer().getOnlinePlayers()) {
                    UUID id = player.getUniqueId();
                    String currentLocale = player.locale().toString();
                    String lastLocale = ClientOptionsListener.this.lastKnownLocales.get(id);
                    if (lastLocale != null && !lastLocale.equals(currentLocale)) {
                        ClientOptionsListener.this.checkAndHandleLocaleChange(player);
                    }
                    ClientOptionsListener.this.lastKnownLocales.put(id, currentLocale);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 100L, 100L);
    }

    private void checkAndHandleLocaleChange(Player p) {
        UUID id = p.getUniqueId();
        Optional<Language> maybe = this.pls.resolveFromLocale(p.locale());
        if (maybe.isEmpty()) {
            return;
        }
        Language detected = maybe.get();
        Language current = this.pls.getLanguage(id).orElse(null);
        if (current != null && current.getCode().equalsIgnoreCase(detected.getCode())) {
            return;
        }
        if (!this.pls.hasLanguage(id)) {
            if (this.cfg.isClientLocaleAutoAccept()) {
                this.pls.setLanguage(id, detected);
                p.sendMessage((Component)Component.text((String)("Set your language to " + detected.getName() + " (" + detected.getCode() + ") based on your client settings."), (TextColor)NamedTextColor.GREEN));
            } else {
                Component prompt = ((TextComponent)((TextComponent)Component.text((String)("Detected your client language: " + detected.getName() + " (" + detected.getCode() + "). "), (TextColor)NamedTextColor.YELLOW).append(Component.text((String)"[Accept]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)("/lang set " + detected.getCode()))))).append((Component)Component.text((String)" "))).append(Component.text((String)"[Choose]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)"/lang")));
                p.sendMessage(prompt);
            }
            return;
        }
        Component prompt = ((TextComponent)((TextComponent)Component.text((String)("Your client language changed to " + detected.getName() + " (" + detected.getCode() + "). "), (TextColor)NamedTextColor.YELLOW).append(Component.text((String)"[Switch]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)("/lang set " + detected.getCode()))))).append((Component)Component.text((String)" "))).append(Component.text((String)"[Keep]", (TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)"/lang view")));
        p.sendMessage(prompt);
    }
}

