/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.listener;

import java.util.Locale;
import java.util.Optional;
import me.autolang.AutoLang;
import me.autolang.api.PlayerLanguageRequestedEvent;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.storage.PlayerLanguageService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class JoinListener
implements Listener {
    private final AutoLang plugin;
    private final ConfigManager cfg;
    private final PlayerLanguageService pls;

    public JoinListener(AutoLang plugin, ConfigManager cfg, PlayerLanguageService pls) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.pls = pls;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!this.pls.hasLanguage(p.getUniqueId())) {
            TextComponent base;
            if (this.cfg.isClientLocaleEnabled()) {
                try {
                    Locale locale = p.locale();
                    Optional<Language> maybe = this.pls.resolveFromLocale(locale);
                    if (maybe.isPresent()) {
                        Language detected = maybe.get();
                        if (this.cfg.isClientLocaleAutoAccept()) {
                            this.pls.setLanguage(p.getUniqueId(), detected);
                            p.sendMessage((Component)Component.text((String)("Set your language to " + detected.getName() + " (" + detected.getCode() + ") based on your client settings."), (TextColor)NamedTextColor.GREEN));
                            return;
                        }
                        Component prompt = ((TextComponent)((TextComponent)Component.text((String)("Detected your client language: " + detected.getName() + " (" + detected.getCode() + "). "), (TextColor)NamedTextColor.YELLOW).append(Component.text((String)"[Accept]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)("/lang set " + detected.getCode()))))).append((Component)Component.text((String)" "))).append(Component.text((String)"[Choose]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)"/lang")));
                        p.sendMessage(prompt);
                        this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerLanguageRequestedEvent(p.getUniqueId()));
                        return;
                    }
                }
                catch (Throwable locale) {
                    // empty catch block
                }
            }
            TextComponent line = base = Component.text((String)"Please choose your language: ", (TextColor)NamedTextColor.YELLOW);
            boolean first = true;
            for (Language lang : this.cfg.getLanguages()) {
                Component btn = Component.text((String)("[" + lang.getName() + "]"), (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("/lang set " + lang.getCode())));
                if (!first) {
                    line = line.append((Component)Component.text((String)" ", (TextColor)NamedTextColor.GRAY));
                }
                first = false;
                line = line.append(btn);
            }
            p.sendMessage((Component)line);
            this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerLanguageRequestedEvent(p.getUniqueId()));
        }
    }
}

