/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.autolang.AutoLang;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.manager.TranslationManager;
import me.autolang.storage.PlayerLanguageService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketChatListener {
    private final AutoLang plugin;
    private final ConfigManager cfg;
    private final PlayerLanguageService pls;
    private final TranslationManager manager;
    private final List<ChatFormatPattern> formatPatterns;
    private static final List<ChatFormatPattern> BUILT_IN_PATTERNS = Arrays.asList(new ChatFormatPattern(Pattern.compile("^<([^>]+)>\\s+(.+)$"), 1, 2, "<{name}> {message}"), new ChatFormatPattern(Pattern.compile("^\\[([^\\]]+)]\\s+(.+)$"), 1, 2, "[{name}] {message}"), new ChatFormatPattern(Pattern.compile("^\\*\\*([^:*]+):\\s*(.+)$"), 1, 2, "**{name}: {message}"), new ChatFormatPattern(Pattern.compile("^([^:]+):\\s+(.+)$"), 1, 2, "{name}: {message}"), new ChatFormatPattern(Pattern.compile("^\\[([^\\]]+)]\\s+([^:]+):\\s+(.+)$"), 2, 3, "[{prefix}] {name}: {message}", 1), new ChatFormatPattern(Pattern.compile("^([^\u00bb]+)\u00bb\\s*(.+)$"), 1, 2, "{name} \u00bb {message}"), new ChatFormatPattern(Pattern.compile("^([^-]+)->\\s*(.+)$"), 1, 2, "{name} -> {message}"), new ChatFormatPattern(Pattern.compile("^([^|]+)\\|\\s*(.+)$"), 1, 2, "{name} | {message}"));

    public PacketChatListener(AutoLang plugin, ConfigManager cfg, PlayerLanguageService pls, TranslationManager manager) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.pls = pls;
        this.manager = manager;
        this.formatPatterns = new ArrayList<ChatFormatPattern>();
        this.loadCustomFormats();
        this.formatPatterns.addAll(BUILT_IN_PATTERNS);
        plugin.getLogger().info("Loaded " + this.formatPatterns.size() + " chat format patterns (" + (this.formatPatterns.size() - BUILT_IN_PATTERNS.size()) + " custom, " + BUILT_IN_PATTERNS.size() + " built-in)");
    }

    private void loadCustomFormats() {
        List<Map<String, Object>> customFormats = this.cfg.getCustomChatFormats();
        if (customFormats == null || customFormats.isEmpty()) {
            return;
        }
        for (Map<String, Object> formatMap : customFormats) {
            try {
                String regex = (String)formatMap.get("regex");
                Object nameGroupObj = formatMap.get("name-group");
                Object messageGroupObj = formatMap.get("message-group");
                Object prefixGroupObj = formatMap.get("prefix-group");
                String template = (String)formatMap.get("template");
                if (regex == null || nameGroupObj == null || messageGroupObj == null || template == null) {
                    this.plugin.getLogger().warning("Incomplete custom chat format definition, skipping");
                    continue;
                }
                int nameGroup = ((Number)nameGroupObj).intValue();
                int messageGroup = ((Number)messageGroupObj).intValue();
                int prefixGroup = prefixGroupObj != null ? ((Number)prefixGroupObj).intValue() : -1;
                Pattern pattern = Pattern.compile(regex);
                this.formatPatterns.add(new ChatFormatPattern(pattern, nameGroup, messageGroup, template, prefixGroup));
                this.plugin.getLogger().info("Loaded custom chat format: " + regex);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load custom chat format: " + e.getMessage());
            }
        }
    }

    public void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SYSTEM_CHAT, PacketType.Play.Server.DISGUISED_CHAT}){

            public void onPacketSending(PacketEvent event) {
                block27: {
                    if (event.isCancelled()) {
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Packet already cancelled");
                        }
                        return;
                    }
                    PacketContainer packet = event.getPacket();
                    Player receiver = event.getPlayer();
                    if (PacketChatListener.this.cfg.isLogMessages()) {
                        this.plugin.getLogger().info("[PacketDebug] Intercepting " + String.valueOf(packet.getType()) + " for " + receiver.getName());
                    }
                    try {
                        Player sender;
                        WrappedChatComponent wrappedComponent = (WrappedChatComponent)packet.getChatComponents().read(0);
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Wrapped component: " + (wrappedComponent != null ? "present" : "null"));
                        }
                        if (wrappedComponent == null || wrappedComponent.getJson() == null) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] No chat component or JSON in packet");
                            }
                            return;
                        }
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] JSON: " + wrappedComponent.getJson());
                        }
                        Component adventureComponent = GsonComponentSerializer.gson().deserialize((Object)wrappedComponent.getJson());
                        String plainText = PlainTextComponentSerializer.plainText().serialize(adventureComponent);
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Plain text: " + plainText);
                        }
                        if (plainText == null || plainText.trim().isEmpty()) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] Plain text is null or empty");
                            }
                            return;
                        }
                        if (plainText.startsWith("!")) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] Skipping bypass message");
                            }
                            return;
                        }
                        ChatMessage parsedMessage = PacketChatListener.this.parseChatMessage(plainText);
                        if (parsedMessage == null) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] No chat format detected, skipping system message");
                            }
                            return;
                        }
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Detected format: " + parsedMessage.detectedFormat + " | Sender: '" + parsedMessage.senderName + "' | Message: '" + parsedMessage.message + "'");
                        }
                        if (parsedMessage.message.isEmpty()) {
                            return;
                        }
                        Language receiverLang = PacketChatListener.this.pls.getLanguage(receiver.getUniqueId()).orElseGet(() -> PacketChatListener.this.cfg.isClientLocaleEnabled() ? PacketChatListener.this.pls.resolveFromLocale(receiver.locale()).orElse(PacketChatListener.this.cfg.getDefaultLanguage()) : PacketChatListener.this.cfg.getDefaultLanguage());
                        Language senderLang = PacketChatListener.this.cfg.getDefaultLanguage();
                        if (parsedMessage.senderName != null && (sender = this.plugin.getServer().getPlayerExact(parsedMessage.senderName)) != null) {
                            senderLang = PacketChatListener.this.pls.getLanguage(sender.getUniqueId()).orElseGet(() -> PacketChatListener.this.cfg.isClientLocaleEnabled() ? PacketChatListener.this.pls.resolveFromLocale(sender.locale()).orElse(PacketChatListener.this.cfg.getDefaultLanguage()) : PacketChatListener.this.cfg.getDefaultLanguage());
                        }
                        Language finalSenderLang = senderLang;
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Receiver lang: " + receiverLang.getCode() + ", Sender lang: " + finalSenderLang.getCode());
                        }
                        if (senderLang.equals(receiverLang)) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] Same language, skipping translation");
                            }
                            return;
                        }
                        if (PacketChatListener.this.cfg.isLogMessages()) {
                            this.plugin.getLogger().info("[PacketDebug] Translating from " + finalSenderLang.getCode() + " to " + receiverLang.getCode());
                        }
                        try {
                            Map translations = (Map)((CompletableFuture)PacketChatListener.this.manager.translateForRecipients(parsedMessage.message, finalSenderLang, Set.of(receiverLang)).orTimeout(PacketChatListener.this.cfg.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS).exceptionally(ex -> Collections.emptyMap())).get(PacketChatListener.this.cfg.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS);
                            String translatedText = translations.getOrDefault(receiverLang, parsedMessage.message);
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().info("[PacketDebug] Translated: " + translatedText);
                            }
                            Component translatedComponent = PacketChatListener.this.replaceMessageInComponent(adventureComponent, parsedMessage.message, translatedText);
                            String translatedJson = (String)GsonComponentSerializer.gson().serialize(translatedComponent);
                            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)translatedJson));
                        }
                        catch (Exception e) {
                            if (PacketChatListener.this.cfg.isLogMessages()) {
                                this.plugin.getLogger().warning("Packet translation failed: " + e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!PacketChatListener.this.cfg.isLogMessages()) break block27;
                        this.plugin.getLogger().warning("Error processing chat packet: " + e.getMessage());
                    }
                }
            }
        });
    }

    private ChatMessage parseChatMessage(String text) {
        for (ChatFormatPattern formatPattern : this.formatPatterns) {
            String prefix;
            Matcher matcher = formatPattern.pattern.matcher(text);
            if (!matcher.matches()) continue;
            String senderName = matcher.group(formatPattern.nameGroup).trim();
            String message = matcher.group(formatPattern.messageGroup).trim();
            String string = prefix = formatPattern.prefixGroup > 0 ? matcher.group(formatPattern.prefixGroup).trim() : null;
            if (!this.isValidPlayerName(senderName)) continue;
            return new ChatMessage(senderName, message, prefix, formatPattern.formatTemplate, formatPattern.pattern.pattern());
        }
        return null;
    }

    private boolean isValidPlayerName(String name) {
        if (name == null || name.isEmpty() || name.length() > 16) {
            return false;
        }
        return name.matches("^[a-zA-Z0-9_]+$");
    }

    private Component replaceMessageInComponent(Component component, String originalMessage, String translatedMessage) {
        return this.replaceInComponent(component, originalMessage, translatedMessage);
    }

    private Component replaceInComponent(Component comp, String original, String translated) {
        List children;
        if (comp instanceof TextComponent) {
            TextComponent textComp = (TextComponent)comp;
            String content = textComp.content();
            if (content.equals(original)) {
                comp = textComp.content(translated);
            } else if (content.contains(original)) {
                comp = textComp.content(content.replace(original, translated));
            }
        }
        if (!(children = comp.children()).isEmpty()) {
            ArrayList<Component> newChildren = new ArrayList<Component>();
            for (Component child : children) {
                newChildren.add(this.replaceInComponent(child, original, translated));
            }
            comp = comp.children(newChildren);
        }
        return comp;
    }

    public void unregister() {
        ProtocolLibrary.getProtocolManager().removePacketListeners((Plugin)this.plugin);
    }

    private static class ChatFormatPattern {
        final Pattern pattern;
        final int nameGroup;
        final int messageGroup;
        final int prefixGroup;
        final String formatTemplate;

        ChatFormatPattern(Pattern pattern, int nameGroup, int messageGroup, String formatTemplate) {
            this(pattern, nameGroup, messageGroup, formatTemplate, -1);
        }

        ChatFormatPattern(Pattern pattern, int nameGroup, int messageGroup, String formatTemplate, int prefixGroup) {
            this.pattern = pattern;
            this.nameGroup = nameGroup;
            this.messageGroup = messageGroup;
            this.formatTemplate = formatTemplate;
            this.prefixGroup = prefixGroup;
        }
    }

    private static class ChatMessage {
        final String senderName;
        final String message;
        final String prefix;
        final String formatTemplate;
        final String detectedFormat;

        ChatMessage(String senderName, String message, String prefix, String formatTemplate, String detectedFormat) {
            this.senderName = senderName;
            this.message = message;
            this.prefix = prefix;
            this.formatTemplate = formatTemplate;
            this.detectedFormat = detectedFormat;
        }

        String reconstruct(String translatedMessage) {
            return this.formatTemplate.replace("{name}", this.senderName).replace("{message}", translatedMessage).replace("{prefix}", this.prefix != null ? this.prefix : "");
        }
    }
}

