/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.manager;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.autolang.AutoLang;
import me.autolang.locale.Language;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.AsyncExecutor;
import me.autolang.util.LRUCache;

public class TranslationManager {
    private final AutoLang plugin;
    private final AsyncExecutor executor;
    private volatile TranslationEngine engine;
    private volatile LRUCache<String, String> cache;
    private volatile int timeoutMs;
    private volatile boolean cacheEnabled;

    public TranslationManager(AutoLang plugin, AsyncExecutor executor, TranslationEngine engine, LRUCache<String, String> cache2, int timeoutMs, boolean cacheEnabled) {
        this.plugin = plugin;
        this.executor = executor;
        this.engine = engine;
        this.cache = cache2;
        this.timeoutMs = timeoutMs;
        this.cacheEnabled = cacheEnabled;
    }

    public void setEngine(TranslationEngine newEngine) {
        this.engine = Objects.requireNonNull(newEngine);
    }

    public void reload(int timeoutMs, boolean cacheEnabled, LRUCache<String, String> newCache) {
        this.timeoutMs = timeoutMs;
        this.cacheEnabled = cacheEnabled;
        if (newCache != null) {
            this.cache = newCache;
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    public CompletableFuture<Map<Language, String>> translateForRecipients(String message, Language source2, Set<Language> targets) {
        ConcurrentHashMap<Language, String> results = new ConcurrentHashMap<Language, String>();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (Language target : targets) {
            String cached;
            if (target.getCode().equalsIgnoreCase(source2.getCode())) {
                results.put(target, message);
                continue;
            }
            String key = TranslationManager.makeCacheKey(message, source2.getCode(), target.getCode(), this.engineCacheTag());
            if (this.cacheEnabled && (cached = this.cache.get(key)) != null) {
                results.put(target, cached);
                continue;
            }
            CompletionStage f = ((CompletableFuture)this.engine.translateAsync(message, source2, target, this.executor).orTimeout(this.timeoutMs, TimeUnit.MILLISECONDS).exceptionally(ex -> message)).whenComplete((translated, ex) -> {
                results.put(target, (String)translated);
                if (this.cacheEnabled) {
                    this.cache.put(key, (String)translated);
                }
            });
            futures.add(f);
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(results);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(v -> results);
    }

    private String engineCacheTag() {
        try {
            return this.engine.getClass().getSimpleName();
        }
        catch (Throwable t) {
            return "engine";
        }
    }

    private static String makeCacheKey(String message, String sourceCode, String targetCode, String engineTag) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String input = message + "|" + sourceCode + "|" + targetCode + "|" + engineTag;
            byte[] hash = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : hash) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return message + "|" + sourceCode + "|" + targetCode + "|" + engineTag;
        }
    }
}

