/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.storage;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.storage.PlayerLanguageStore;

public class PlayerLanguageService {
    private final ConfigManager config;
    private final PlayerLanguageStore store;
    private final File dataFolder;
    private final Map<UUID, Integer> messageCounters = new ConcurrentHashMap<UUID, Integer>();

    public PlayerLanguageService(ConfigManager config, PlayerLanguageStore store, File dataFolder) {
        this.config = config;
        this.store = store;
        this.dataFolder = dataFolder;
    }

    public Optional<Language> getLanguage(UUID uuid) {
        Optional<String> code = this.store.getLanguageCode(uuid);
        return code.map(c -> Optional.ofNullable(this.config.getLanguageByCode((String)c)).orElse(new Language((String)c, (String)c)));
    }

    public void setLanguage(UUID uuid, Language language) {
        if (language == null) {
            return;
        }
        this.store.setLanguageCode(uuid, language.getCode());
        this.resetDetectionCounter(uuid);
    }

    public boolean hasLanguage(UUID uuid) {
        return this.store.hasLanguage(uuid);
    }

    public Language getDefaultLanguage() {
        return this.config.getDefaultLanguage();
    }

    public boolean shouldAttemptDetection(UUID uuid) {
        if (!this.config.isAutodetectEnabled()) {
            return false;
        }
        int n = this.messageCounters.merge(uuid, 1, Integer::sum);
        return n >= this.config.getMinMessagesBeforeDetect();
    }

    public void resetDetectionCounter(UUID uuid) {
        this.messageCounters.remove(uuid);
    }

    public Map<UUID, String> exportAll() {
        return this.store.getAll();
    }

    public void importAll(Map<UUID, String> data2) {
        this.store.importAll(data2);
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public void shutdown() {
        this.store.shutdown();
    }

    public Optional<Language> resolveFromLocale(Locale locale) {
        if (locale == null) {
            return Optional.empty();
        }
        try {
            String base = locale.getLanguage();
            if (base != null && this.config.isLanguageSupported(base = base.toLowerCase(Locale.ROOT))) {
                return Optional.ofNullable(this.config.getLanguageByCode(base));
            }
            String tag = locale.toLanguageTag();
            if (tag != null) {
                if (this.config.isLanguageSupported(tag = tag.toLowerCase(Locale.ROOT))) {
                    return Optional.ofNullable(this.config.getLanguageByCode(tag));
                }
                String mc = tag.replace('-', '_');
                if (this.config.isLanguageSupported(mc)) {
                    return Optional.ofNullable(this.config.getLanguageByCode(mc));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }
}

