/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.autolang.config.ConfigManager;
import me.autolang.storage.PlayerLanguageStore;

public class SQLitePlayerLanguageStore
implements PlayerLanguageStore {
    private final String dbUrl;
    private final Logger log;

    public SQLitePlayerLanguageStore(ConfigManager cfg, Logger log) {
        this.dbUrl = "jdbc:sqlite:" + cfg.getSqliteFile();
        this.log = log;
        this.init();
    }

    private void init() {
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             Statement st = c.createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS player_lang (uuid TEXT PRIMARY KEY, lang TEXT, updated_at INTEGER)");
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Failed to init SQLite store", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> getLanguageCode(UUID playerUuid) {
        String sql = "SELECT lang FROM player_lang WHERE uuid = ?";
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             PreparedStatement ps = c.prepareStatement(sql);){
            ps.setString(1, playerUuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Optional.empty();
                Optional<String> optional = Optional.ofNullable(rs.getString(1));
                return optional;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "SQLite getLanguageCode failed", e);
        }
        return Optional.empty();
    }

    @Override
    public void setLanguageCode(UUID playerUuid, String code) {
        String sql = "INSERT INTO player_lang(uuid, lang, updated_at) VALUES(?,?,?) ON CONFLICT(uuid) DO UPDATE SET lang=excluded.lang, updated_at=excluded.updated_at";
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             PreparedStatement ps = c.prepareStatement(sql);){
            ps.setString(1, playerUuid.toString());
            ps.setString(2, code);
            ps.setLong(3, System.currentTimeMillis());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "SQLite setLanguageCode failed", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasLanguage(UUID playerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<UUID, String> getAll() {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        String sql = "SELECT uuid, lang FROM player_lang";
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             PreparedStatement ps = c.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                try {
                    UUID id = UUID.fromString(rs.getString(1));
                    String lang = rs.getString(2);
                    if (lang == null) continue;
                    map.put(id, lang);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return map;
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "SQLite getAll failed", e);
        }
        return map;
    }

    @Override
    public void importAll(Map<UUID, String> data2) {
        String sql = "INSERT INTO player_lang(uuid, lang, updated_at) VALUES(?,?,?) ON CONFLICT(uuid) DO UPDATE SET lang=excluded.lang, updated_at=excluded.updated_at";
        try (Connection c = DriverManager.getConnection(this.dbUrl);){
            c.setAutoCommit(false);
            try (PreparedStatement ps = c.prepareStatement(sql);){
                for (Map.Entry<UUID, String> e : data2.entrySet()) {
                    ps.setString(1, e.getKey().toString());
                    ps.setString(2, e.getValue());
                    ps.setLong(3, System.currentTimeMillis());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            c.commit();
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "SQLite importAll failed", e);
        }
    }

    @Override
    public void shutdown() {
    }
}

