/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.autolang.AutoLang;
import me.autolang.storage.PlayerLanguageStore;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlPlayerLanguageStore
implements PlayerLanguageStore {
    private final AutoLang plugin;
    private final File playersDir;

    public YamlPlayerLanguageStore(AutoLang plugin) {
        this.plugin = plugin;
        this.playersDir = new File(plugin.getDataFolder(), "players");
        if (!this.playersDir.exists()) {
            this.playersDir.mkdirs();
        }
    }

    private File fileFor(UUID uuid) {
        return new File(this.playersDir, uuid.toString() + ".yml");
    }

    @Override
    public Optional<String> getLanguageCode(UUID playerUuid) {
        File f = this.fileFor(playerUuid);
        if (!f.exists()) {
            return Optional.empty();
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
        String lang = cfg.getString("language", null);
        if (lang == null) {
            return Optional.empty();
        }
        return Optional.of(lang);
    }

    @Override
    public void setLanguageCode(UUID playerUuid, String code) {
        File f = this.fileFor(playerUuid);
        YamlConfiguration cfg = new YamlConfiguration();
        cfg.set("language", (Object)code);
        cfg.set("updated_at", (Object)System.currentTimeMillis());
        try {
            cfg.save(f);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save player language YAML", e);
        }
    }

    @Override
    public boolean hasLanguage(UUID playerUuid) {
        return this.fileFor(playerUuid).exists();
    }

    @Override
    public Map<UUID, String> getAll() {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        File[] files = this.playersDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return map;
        }
        for (File f : files) {
            try {
                String uuidStr = f.getName().substring(0, f.getName().length() - 4);
                UUID uuid = UUID.fromString(uuidStr);
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
                String lang = cfg.getString("language", null);
                if (lang == null) continue;
                map.put(uuid, lang);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    @Override
    public void importAll(Map<UUID, String> data2) {
        for (Map.Entry<UUID, String> e : data2.entrySet()) {
            this.setLanguageCode(e.getKey(), e.getValue());
        }
    }

    @Override
    public void shutdown() {
    }
}

