/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.translate;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import me.autolang.config.ConfigManager;
import me.autolang.libs.gson.Gson;
import me.autolang.libs.gson.JsonObject;
import me.autolang.locale.Language;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.AsyncExecutor;

public class LibreTranslateEngineAdapter
implements TranslationEngine {
    private final ConfigManager cfg;
    private final AsyncExecutor executor;
    private final Logger log;
    private final HttpClient client;
    private final Gson gson = new Gson();

    public LibreTranslateEngineAdapter(ConfigManager cfg, AsyncExecutor executor, Logger log) {
        this.cfg = cfg;
        this.executor = executor;
        this.log = log;
        this.client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
    }

    @Override
    public String translate(String sourceText, Language from, Language to) throws Exception {
        if (from.getCode().equalsIgnoreCase(to.getCode())) {
            return sourceText;
        }
        String base = this.cfg.getLibreTranslateBaseUrl();
        if (!this.isLocalhost(base) && !this.cfg.isLibreTranslateAllowRemote()) {
            this.log.warning("LibreTranslate base-url is remote and allow-remote is false. Skipping translation.");
            return sourceText;
        }
        URI uri = URI.create(base.endsWith("/") ? base + "translate" : base + "/translate");
        JsonObject body = new JsonObject();
        body.addProperty("q", sourceText);
        body.addProperty("source", from.getCode());
        body.addProperty("target", to.getCode());
        body.addProperty("format", "text");
        String json = this.gson.toJson(body);
        HttpRequest req = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
        HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (resp.statusCode() != 200) {
            this.log.warning("LibreTranslate returned status " + resp.statusCode());
            return sourceText;
        }
        JsonObject obj = this.gson.fromJson(resp.body(), JsonObject.class);
        if (obj == null || !obj.has("translatedText")) {
            return sourceText;
        }
        String translated = obj.get("translatedText").getAsString();
        if (translated == null || translated.isBlank()) {
            return sourceText;
        }
        return translated;
    }

    @Override
    public CompletableFuture<String> translateAsync(String sourceText, Language from, Language to, AsyncExecutor executor) {
        if (from.getCode().equalsIgnoreCase(to.getCode())) {
            return CompletableFuture.completedFuture(sourceText);
        }
        String base = this.cfg.getLibreTranslateBaseUrl();
        if (!this.isLocalhost(base) && !this.cfg.isLibreTranslateAllowRemote()) {
            return CompletableFuture.completedFuture(sourceText);
        }
        URI uri = URI.create(base.endsWith("/") ? base + "translate" : base + "/translate");
        JsonObject body = new JsonObject();
        body.addProperty("q", sourceText);
        body.addProperty("source", from.getCode());
        body.addProperty("target", to.getCode());
        body.addProperty("format", "text");
        String json = this.gson.toJson(body);
        HttpRequest req = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
        return ((CompletableFuture)this.client.sendAsync(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(resp -> {
            if (resp.statusCode() != 200) {
                return sourceText;
            }
            JsonObject obj = this.gson.fromJson((String)resp.body(), JsonObject.class);
            if (obj == null || !obj.has("translatedText")) {
                return sourceText;
            }
            String translated = obj.get("translatedText").getAsString();
            if (translated == null || translated.isBlank()) {
                return sourceText;
            }
            return translated;
        })).exceptionally(ex -> sourceText);
    }

    private boolean isLocalhost(String base) {
        try {
            URI u = URI.create(Objects.requireNonNullElse(base, ""));
            String host = u.getHost();
            if (host == null) {
                return true;
            }
            return host.equals("127.0.0.1") || host.equalsIgnoreCase("localhost") || host.equals("::1");
        }
        catch (Exception e) {
            return false;
        }
    }
}

