/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.translate;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import me.autolang.config.ConfigManager;
import me.autolang.locale.Language;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.AsyncExecutor;

public class LocalModelEngineAdapter
implements TranslationEngine {
    private final ConfigManager cfg;
    private final AsyncExecutor executor;
    private final Logger log;

    public LocalModelEngineAdapter(ConfigManager cfg, AsyncExecutor executor, Logger log) {
        this.cfg = cfg;
        this.executor = executor;
        this.log = log;
    }

    @Override
    public String translate(String sourceText, Language from, Language to) throws Exception {
        if (from.getCode().equalsIgnoreCase(to.getCode())) {
            return sourceText;
        }
        String command = this.cfg.getLocalModelCommand();
        if (command == null || command.isBlank()) {
            return sourceText;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(command);
        cmd.add("--from");
        cmd.add(from.getCode());
        cmd.add("--to");
        cmd.add(to.getCode());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        try (OutputStream os = p.getOutputStream();){
            os.write(sourceText.getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        StringBuilder out = new StringBuilder();
        try (InputStream is = p.getInputStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                out.append(line).append('\n');
            }
        }
        int code = p.waitFor();
        String result2 = out.toString().trim();
        if (code != 0) {
            this.log.warning("LocalModelEngineAdapter process exited with code " + code + ", returning original message.");
            return sourceText;
        }
        if (result2.isEmpty()) {
            return sourceText;
        }
        return result2;
    }

    @Override
    public CompletableFuture<String> translateAsync(String sourceText, Language from, Language to, AsyncExecutor executor) {
        return TranslationEngine.super.translateAsync(sourceText, from, to, this.executor);
    }

    public void shutdown() {
    }
}

