/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.translate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.autolang.locale.Language;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.AsyncExecutor;

public class RulebookEngine
implements TranslationEngine {
    private final AsyncExecutor executor;
    private static final Map<String, Map<String, String>> DICT = new HashMap<String, Map<String, String>>();
    private static final Map<String, Pattern> WORD_BOUNDARY_PATTERNS = new HashMap<String, Pattern>();
    private static final Map<String, Map<Pattern, String>> REGEX_PATTERNS = new HashMap<String, Map<Pattern, String>>();

    private static void initializeDictionaries() {
        HashMap<String, String> en_es = new HashMap<String, String>();
        en_es.put("hello", "hola");
        en_es.put("hi", "hola");
        en_es.put("hey", "oye");
        en_es.put("good morning", "buenos d\u00edas");
        en_es.put("good afternoon", "buenas tardes");
        en_es.put("good evening", "buenas tardes");
        en_es.put("good night", "buenas noches");
        en_es.put("goodbye", "adi\u00f3s");
        en_es.put("bye", "adi\u00f3s");
        en_es.put("see you later", "hasta luego");
        en_es.put("see you soon", "hasta pronto");
        en_es.put("thank you", "gracias");
        en_es.put("thanks", "gracias");
        en_es.put("thank you very much", "muchas gracias");
        en_es.put("please", "por favor");
        en_es.put("excuse me", "disculpe");
        en_es.put("sorry", "lo siento");
        en_es.put("you're welcome", "de nada");
        en_es.put("yes", "s\u00ed");
        en_es.put("no", "no");
        en_es.put("maybe", "tal vez");
        en_es.put("of course", "por supuesto");
        en_es.put("certainly", "ciertamente");
        en_es.put("absolutely", "absolutamente");
        en_es.put("how are you", "c\u00f3mo est\u00e1s");
        en_es.put("what is your name", "c\u00f3mo te llamas");
        en_es.put("where are you from", "de d\u00f3nde eres");
        en_es.put("how old are you", "cu\u00e1ntos a\u00f1os tienes");
        en_es.put("what time is it", "qu\u00e9 hora es");
        en_es.put("how much does it cost", "cu\u00e1nto cuesta");
        en_es.put("where is", "d\u00f3nde est\u00e1");
        en_es.put("do you speak english", "hablas ingl\u00e9s");
        en_es.put("i don't understand", "no entiendo");
        en_es.put("can you help me", "puedes ayudarme");
        en_es.put("i am", "soy");
        en_es.put("you are", "eres");
        en_es.put("he is", "\u00e9l es");
        en_es.put("she is", "ella es");
        en_es.put("we are", "somos");
        en_es.put("they are", "son");
        en_es.put("i have", "tengo");
        en_es.put("you have", "tienes");
        en_es.put("i want", "quiero");
        en_es.put("i need", "necesito");
        en_es.put("i like", "me gusta");
        en_es.put("i love", "amo");
        en_es.put("i know", "s\u00e9");
        en_es.put("i don't know", "no s\u00e9");
        en_es.put("one", "uno");
        en_es.put("two", "dos");
        en_es.put("three", "tres");
        en_es.put("four", "cuatro");
        en_es.put("five", "cinco");
        en_es.put("six", "seis");
        en_es.put("seven", "siete");
        en_es.put("eight", "ocho");
        en_es.put("nine", "nueve");
        en_es.put("ten", "diez");
        en_es.put("today", "hoy");
        en_es.put("yesterday", "ayer");
        en_es.put("tomorrow", "ma\u00f1ana");
        en_es.put("now", "ahora");
        en_es.put("later", "m\u00e1s tarde");
        en_es.put("always", "siempre");
        en_es.put("never", "nunca");
        en_es.put("good", "bueno");
        en_es.put("bad", "malo");
        en_es.put("big", "grande");
        en_es.put("small", "peque\u00f1o");
        en_es.put("hot", "caliente");
        en_es.put("cold", "fr\u00edo");
        en_es.put("beautiful", "hermoso");
        en_es.put("ugly", "feo");
        en_es.put("easy", "f\u00e1cil");
        en_es.put("difficult", "dif\u00edcil");
        DICT.put("en->es", en_es);
        HashMap<String, String> en_fr = new HashMap<String, String>();
        en_fr.put("hello", "bonjour");
        en_fr.put("hi", "salut");
        en_fr.put("hey", "salut");
        en_fr.put("good morning", "bonjour");
        en_fr.put("good afternoon", "bon apr\u00e8s-midi");
        en_fr.put("good evening", "bonsoir");
        en_fr.put("good night", "bonne nuit");
        en_fr.put("goodbye", "au revoir");
        en_fr.put("bye", "salut");
        en_fr.put("see you later", "\u00e0 bient\u00f4t");
        en_fr.put("see you soon", "\u00e0 bient\u00f4t");
        en_fr.put("thank you", "merci");
        en_fr.put("thanks", "merci");
        en_fr.put("thank you very much", "merci beaucoup");
        en_fr.put("please", "s'il vous pla\u00eet");
        en_fr.put("excuse me", "excusez-moi");
        en_fr.put("sorry", "d\u00e9sol\u00e9");
        en_fr.put("you're welcome", "de rien");
        en_fr.put("yes", "oui");
        en_fr.put("no", "non");
        en_fr.put("maybe", "peut-\u00eatre");
        en_fr.put("of course", "bien s\u00fbr");
        en_fr.put("certainly", "certainement");
        en_fr.put("absolutely", "absolument");
        en_fr.put("how are you", "comment allez-vous");
        en_fr.put("what is your name", "comment vous appelez-vous");
        en_fr.put("where are you from", "d'o\u00f9 venez-vous");
        en_fr.put("how old are you", "quel \u00e2ge avez-vous");
        en_fr.put("what time is it", "quelle heure est-il");
        en_fr.put("how much does it cost", "combien \u00e7a co\u00fbte");
        en_fr.put("where is", "o\u00f9 est");
        en_fr.put("do you speak english", "parlez-vous anglais");
        en_fr.put("i don't understand", "je ne comprends pas");
        en_fr.put("can you help me", "pouvez-vous m'aider");
        en_fr.put("i am", "je suis");
        en_fr.put("you are", "vous \u00eates");
        en_fr.put("he is", "il est");
        en_fr.put("she is", "elle est");
        en_fr.put("we are", "nous sommes");
        en_fr.put("they are", "ils sont");
        en_fr.put("i have", "j'ai");
        en_fr.put("you have", "vous avez");
        en_fr.put("i want", "je veux");
        en_fr.put("i need", "j'ai besoin");
        en_fr.put("i like", "j'aime");
        en_fr.put("i love", "j'adore");
        en_fr.put("i know", "je sais");
        en_fr.put("i don't know", "je ne sais pas");
        en_fr.put("one", "un");
        en_fr.put("two", "deux");
        en_fr.put("three", "trois");
        en_fr.put("four", "quatre");
        en_fr.put("five", "cinq");
        en_fr.put("six", "six");
        en_fr.put("seven", "sept");
        en_fr.put("eight", "huit");
        en_fr.put("nine", "neuf");
        en_fr.put("ten", "dix");
        en_fr.put("today", "aujourd'hui");
        en_fr.put("yesterday", "hier");
        en_fr.put("tomorrow", "demain");
        en_fr.put("now", "maintenant");
        en_fr.put("later", "plus tard");
        en_fr.put("always", "toujours");
        en_fr.put("never", "jamais");
        en_fr.put("good", "bon");
        en_fr.put("bad", "mauvais");
        en_fr.put("big", "grand");
        en_fr.put("small", "petit");
        en_fr.put("hot", "chaud");
        en_fr.put("cold", "froid");
        en_fr.put("beautiful", "beau");
        en_fr.put("ugly", "laid");
        en_fr.put("easy", "facile");
        en_fr.put("difficult", "difficile");
        DICT.put("en->fr", en_fr);
        HashMap<String, String> en_de = new HashMap<String, String>();
        en_de.put("hello", "hallo");
        en_de.put("hi", "hallo");
        en_de.put("hey", "hey");
        en_de.put("good morning", "guten Morgen");
        en_de.put("good afternoon", "guten Tag");
        en_de.put("good evening", "guten Abend");
        en_de.put("good night", "gute Nacht");
        en_de.put("goodbye", "auf Wiedersehen");
        en_de.put("bye", "tsch\u00fcss");
        en_de.put("see you later", "bis sp\u00e4ter");
        en_de.put("thank you", "danke");
        en_de.put("thanks", "danke");
        en_de.put("thank you very much", "vielen Dank");
        en_de.put("please", "bitte");
        en_de.put("excuse me", "entschuldigen Sie");
        en_de.put("sorry", "es tut mir leid");
        en_de.put("you're welcome", "bitte sch\u00f6n");
        en_de.put("yes", "ja");
        en_de.put("no", "nein");
        en_de.put("maybe", "vielleicht");
        en_de.put("of course", "nat\u00fcrlich");
        en_de.put("certainly", "sicherlich");
        DICT.put("en->de", en_de);
        HashMap<String, String> en_it = new HashMap<String, String>();
        en_it.put("hello", "ciao");
        en_it.put("hi", "ciao");
        en_it.put("good morning", "buongiorno");
        en_it.put("good evening", "buonasera");
        en_it.put("good night", "buonanotte");
        en_it.put("goodbye", "arrivederci");
        en_it.put("thank you", "grazie");
        en_it.put("thanks", "grazie");
        en_it.put("please", "per favore");
        en_it.put("excuse me", "scusi");
        en_it.put("sorry", "mi dispiace");
        en_it.put("you're welcome", "prego");
        en_it.put("yes", "s\u00ec");
        en_it.put("no", "no");
        en_it.put("maybe", "forse");
        DICT.put("en->it", en_it);
        RulebookEngine.createReverseMappings("en", "es");
        RulebookEngine.createReverseMappings("en", "fr");
        RulebookEngine.createReverseMappings("en", "de");
        RulebookEngine.createReverseMappings("en", "it");
        RulebookEngine.createCrossLanguageMappings();
    }

    private static void createReverseMappings(String lang1, String lang2) {
        String forwardKey = lang1 + "->" + lang2;
        String reverseKey = lang2 + "->" + lang1;
        Map<String, String> forwardDict = DICT.get(forwardKey);
        if (forwardDict != null) {
            HashMap<String, String> reverseDict = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : forwardDict.entrySet()) {
                reverseDict.put(entry.getValue(), entry.getKey());
            }
            DICT.put(reverseKey, reverseDict);
        }
    }

    private static void createCrossLanguageMappings() {
        RulebookEngine.createViaBridgeMapping("es", "fr", "en");
        RulebookEngine.createViaBridgeMapping("fr", "es", "en");
        RulebookEngine.createViaBridgeMapping("es", "de", "en");
        RulebookEngine.createViaBridgeMapping("de", "es", "en");
        RulebookEngine.createViaBridgeMapping("fr", "de", "en");
        RulebookEngine.createViaBridgeMapping("de", "fr", "en");
        RulebookEngine.createViaBridgeMapping("es", "it", "en");
        RulebookEngine.createViaBridgeMapping("it", "es", "en");
        RulebookEngine.createViaBridgeMapping("fr", "it", "en");
        RulebookEngine.createViaBridgeMapping("it", "fr", "en");
        RulebookEngine.createViaBridgeMapping("de", "it", "en");
        RulebookEngine.createViaBridgeMapping("it", "de", "en");
    }

    private static void createViaBridgeMapping(String from, String to, String bridge) {
        String fromToBridge = from + "->" + bridge;
        String bridgeToTo = bridge + "->" + to;
        Map<String, String> fromToBridgeDict = DICT.get(fromToBridge);
        Map<String, String> bridgeToToDict = DICT.get(bridgeToTo);
        if (fromToBridgeDict != null && bridgeToToDict != null) {
            HashMap<String, String> directDict = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : fromToBridgeDict.entrySet()) {
                String bridgeWord = entry.getValue();
                String targetWord = bridgeToToDict.get(bridgeWord);
                if (targetWord == null) continue;
                directDict.put(entry.getKey(), targetWord);
            }
            DICT.put(from + "->" + to, directDict);
        }
    }

    private static void initializeRegexPatterns() {
        HashMap<Pattern, String> en_es_patterns = new HashMap<Pattern, String>();
        en_es_patterns.put(Pattern.compile("\\bmy name is\\s+(\\w+)", 2), "me llamo $1");
        en_es_patterns.put(Pattern.compile("\\bi am (\\d+) years old", 2), "tengo $1 a\u00f1os");
        en_es_patterns.put(Pattern.compile("\\bi am from (.+)", 2), "soy de $1");
        en_es_patterns.put(Pattern.compile("\\bi live in (.+)", 2), "vivo en $1");
        en_es_patterns.put(Pattern.compile("\\bdo you have (.+)\\?", 2), "\u00bftienes $1?");
        en_es_patterns.put(Pattern.compile("\\bwhere is the (.+)\\?", 2), "\u00bfd\u00f3nde est\u00e1 el $1?");
        en_es_patterns.put(Pattern.compile("\\bi would like (.+)", 2), "me gustar\u00eda $1");
        REGEX_PATTERNS.put("en->es", en_es_patterns);
        HashMap<Pattern, String> en_fr_patterns = new HashMap<Pattern, String>();
        en_fr_patterns.put(Pattern.compile("\\bmy name is\\s+(\\w+)", 2), "je m'appelle $1");
        en_fr_patterns.put(Pattern.compile("\\bi am (\\d+) years old", 2), "j'ai $1 ans");
        en_fr_patterns.put(Pattern.compile("\\bi am from (.+)", 2), "je viens de $1");
        en_fr_patterns.put(Pattern.compile("\\bi live in (.+)", 2), "j'habite \u00e0 $1");
        en_fr_patterns.put(Pattern.compile("\\bdo you have (.+)\\?", 2), "avez-vous $1?");
        en_fr_patterns.put(Pattern.compile("\\bwhere is the (.+)\\?", 2), "o\u00f9 est le $1?");
        en_fr_patterns.put(Pattern.compile("\\bi would like (.+)", 2), "j'aimerais $1");
        REGEX_PATTERNS.put("en->fr", en_fr_patterns);
    }

    public RulebookEngine(AsyncExecutor executor) {
        this.executor = executor;
    }

    @Override
    public String translate(String sourceText, Language from, Language to) {
        if (from.getCode().equalsIgnoreCase(to.getCode())) {
            return sourceText;
        }
        String key = from.getCode().toLowerCase(Locale.ROOT) + "->" + to.getCode().toLowerCase(Locale.ROOT);
        String result2 = this.applyRegexPatterns(sourceText, key);
        Map<String, String> dict = DICT.get(key);
        if (dict != null) {
            result2 = this.replaceByDict(dict, result2);
        }
        return result2.equals(sourceText) ? sourceText : result2;
    }

    @Override
    public CompletableFuture<String> translateAsync(String sourceText, Language from, Language to, AsyncExecutor executor) {
        return TranslationEngine.super.translateAsync(sourceText, from, to, executor);
    }

    private String applyRegexPatterns(String text, String key) {
        Map<Pattern, String> patterns = REGEX_PATTERNS.get(key);
        if (patterns == null) {
            return text;
        }
        String result2 = text;
        for (Map.Entry<Pattern, String> entry : patterns.entrySet()) {
            Matcher matcher = entry.getKey().matcher(result2);
            if (!matcher.find()) continue;
            result2 = matcher.replaceAll(entry.getValue());
        }
        return result2;
    }

    private String replaceByDict(Map<String, String> dict, String text) {
        String result2 = text;
        List sortedEntries = dict.entrySet().stream().sorted((a, b) -> Integer.compare(((String)b.getKey()).length(), ((String)a.getKey()).length())).collect(Collectors.toList());
        for (Map.Entry entry : sortedEntries) {
            String replacement;
            String searchKey = (String)entry.getKey();
            if ((result2 = this.replaceWithWordBoundary(result2, searchKey, replacement = (String)entry.getValue())).equals(text)) {
                result2 = RulebookEngine.replaceIgnoreCase(result2, searchKey, replacement);
            }
            if (result2.equals(text)) continue;
            text = result2;
        }
        return result2;
    }

    private String replaceWithWordBoundary(String text, String search, String replacement) {
        if (search.contains(" ")) {
            Pattern pattern = Pattern.compile("\\b" + Pattern.quote(search) + "\\b", 66);
            return pattern.matcher(text).replaceAll(replacement);
        }
        Pattern pattern = Pattern.compile("\\b" + Pattern.quote(search) + "\\b", 66);
        return pattern.matcher(text).replaceAll(replacement);
    }

    private static String replaceIgnoreCase(String text, String search, String replacement) {
        if (search.isEmpty()) {
            return text;
        }
        int idx = 0;
        String lower = text.toLowerCase(Locale.ROOT);
        String lowerSearch = search.toLowerCase(Locale.ROOT);
        StringBuilder sb = new StringBuilder();
        while (true) {
            int pos;
            if ((pos = lower.indexOf(lowerSearch, idx)) < 0) break;
            if (pos > 0 && Character.isLetterOrDigit(text.charAt(pos - 1))) {
                sb.append(text.charAt(pos));
                idx = pos + 1;
                continue;
            }
            int endPos = pos + lowerSearch.length();
            if (endPos < text.length() && Character.isLetterOrDigit(text.charAt(endPos))) {
                sb.append(text.charAt(pos));
                idx = pos + 1;
                continue;
            }
            sb.append(text, idx, pos);
            sb.append(replacement);
            idx = endPos;
        }
        sb.append(text.substring(idx));
        return sb.toString();
    }

    static {
        RulebookEngine.initializeDictionaries();
        RulebookEngine.initializeRegexPatterns();
    }
}

