/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class LRUCache<K, V> {
    private final int capacity;
    private final long ttlMillis;
    private final Map<K, Entry<V>> map;

    public LRUCache(int capacity) {
        this(capacity, 0);
    }

    public LRUCache(int capacity, int ttlSeconds) {
        this.capacity = Math.max(1, capacity);
        this.ttlMillis = (long)Math.max(0, ttlSeconds) * 1000L;
        this.map = new LinkedHashMap<K, Entry<V>>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Entry<V>> eldest) {
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    public synchronized void put(K key, V value) {
        Objects.requireNonNull(key, "key");
        this.map.put(key, new Entry<V>(value));
    }

    public synchronized V get(K key) {
        long age;
        Entry<V> e = this.map.get(key);
        if (e == null) {
            return null;
        }
        if (this.ttlMillis > 0L && (age = System.currentTimeMillis() - e.createdAtMillis) > this.ttlMillis) {
            this.map.remove(key);
            return null;
        }
        return e.value;
    }

    public synchronized boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int size() {
        return this.map.size();
    }

    private static class Entry<V> {
        final V value;
        final long createdAtMillis;

        Entry(V value) {
            this.value = value;
            this.createdAtMillis = System.currentTimeMillis();
        }
    }
}

