/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.rendering.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.ForgeHooksClient;

public class TransparentItemRenderer {
    public static void transformAndRenderModel(BakedModel model, ItemDisplayContext transformType, int color, int light, int overlay, PoseStack poseStack, MultiBufferSource buffer) {
        boolean leftHand = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        poseStack.m_85836_();
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        TransparentItemRenderer.renderModelLists(ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)transformType, (boolean)leftHand), color, light, overlay, poseStack, buffer.m_6299_(Sheets.m_110792_()));
        poseStack.m_85849_();
    }

    public static void renderModelLists(BakedModel model, int color, int combinedLight, int combinedOverlay, PoseStack poseStack, VertexConsumer buffer) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            TransparentItemRenderer.renderQuadList(poseStack, buffer, model.m_213637_(null, direction, randomsource), color, combinedLight, combinedOverlay);
        }
        randomsource.m_188584_(42L);
        TransparentItemRenderer.renderQuadList(poseStack, buffer, model.m_213637_(null, null, randomsource), color, combinedLight, combinedOverlay);
    }

    public static void renderQuadList(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, int color, int combinedLight, int combinedOverlay) {
        PoseStack.Pose pose = poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            if (!quad.m_111304_()) {
                return;
            }
            buffer.putBulkData(pose, quad, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f, combinedLight, combinedOverlay, true);
        }
    }
}

