/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.loot.numberprovider.entity;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.data.loot.PetrolparkGson;
import com.petrolpark.data.loot.PetrolparkLootEntityNumberProviderTypes;
import com.petrolpark.data.loot.numberprovider.entity.EntityNumberProvider;
import com.petrolpark.data.loot.numberprovider.entity.LootEntityNumberProviderType;
import com.petrolpark.data.loot.numberprovider.itemstack.ItemStackNumberProvider;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public class EquipmentNumberProvider
implements EntityNumberProvider {
    public final EquipmentSlot equipmentSlot;
    public final ItemStackNumberProvider itemNumberProvider;

    public EquipmentNumberProvider(EquipmentSlot equipmentSlot, ItemStackNumberProvider itemNumberProvider) {
        this.equipmentSlot = equipmentSlot;
        this.itemNumberProvider = itemNumberProvider;
    }

    @Override
    public float getFloat(Entity entity, LootContext lootContext) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.itemNumberProvider.getFloat(livingEntity.m_6844_(this.equipmentSlot), lootContext);
        }
        return 0.0f;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return this.itemNumberProvider.m_6231_();
    }

    @Override
    public LootEntityNumberProviderType getType() {
        return (LootEntityNumberProviderType)((Object)PetrolparkLootEntityNumberProviderTypes.EQUIPMENT.get());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EquipmentNumberProvider> {
        public void serialize(JsonObject json, EquipmentNumberProvider value, JsonSerializationContext serializationContext) {
            json.addProperty("slot", value.equipmentSlot.m_20751_());
            json.add("value", PetrolparkGson.get().toJsonTree((Object)value.itemNumberProvider));
        }

        public EquipmentNumberProvider deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            return new EquipmentNumberProvider(EquipmentSlot.m_20747_((String)GsonHelper.m_13906_((JsonObject)json, (String)"slot")), (ItemStackNumberProvider)PetrolparkGson.get().fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"value"), ItemStackNumberProvider.class));
        }
    }
}

