/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.petrolpark.data.IEntityTarget;
import com.petrolpark.data.reward.AbstractGiveEntityItemsReward;
import com.petrolpark.data.reward.RewardType;
import com.petrolpark.data.reward.RewardTypes;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class GiveItemReward
extends AbstractGiveEntityItemsReward {
    protected final ItemStack stack;

    public GiveItemReward(IEntityTarget target, ItemStack stack) {
        super(target);
        this.stack = stack;
    }

    @Override
    public Stream<ItemStack> streamStacks(Entity recipient, LootContext context) {
        return Stream.of(this.stack);
    }

    @Override
    public void render(GuiGraphics graphics) {
        graphics.m_280480_(this.stack, 0, 0);
    }

    @Override
    public Component getName() {
        return this.stack.m_41611_();
    }

    @Override
    public RewardType getType() {
        return (RewardType)((Object)RewardTypes.GIVE_ITEM.get());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<GiveItemReward> {
        public void serialize(JsonObject json, GiveItemReward value, JsonSerializationContext serializationContext) {
            json.addProperty("target", value.target.name());
            ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value.stack).resultOrPartial(err -> {
                throw new IllegalStateException((String)err);
            }).ifPresent(element -> json.add("item", element));
        }

        public GiveItemReward deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            IEntityTarget target = IEntityTarget.getByName(GsonHelper.m_13906_((JsonObject)json, (String)"target"));
            Optional op = ItemStack.f_41582_.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13930_((JsonObject)json, (String)"item")).resultOrPartial(err -> {
                throw new JsonSyntaxException(err);
            });
            if (!op.isPresent()) {
                throw new JsonSyntaxException("Give Item Reward specifies no or invalid Item Stack");
            }
            return new GiveItemReward(target, (ItemStack)((Pair)op.get()).getFirst());
        }
    }
}

