/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.item.decay;

import com.petrolpark.Petrolpark;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public interface DecayingItemHandler {
    public static final DecayingItemHandler DUMMY = new DecayingItemHandler(){

        @Override
        public long getGameTime() {
            return 0L;
        }

        @Override
        public boolean isClientSide() {
            return false;
        }
    };

    public long getGameTime();

    public boolean isClientSide();

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientDecayingItemHandler
    implements DecayingItemHandler {
        private final Minecraft minecraft = Minecraft.m_91087_();

        @Override
        public long getGameTime() {
            return this.minecraft.f_91073_.m_46467_();
        }

        @Override
        public boolean isClientSide() {
            return true;
        }
    }

    @Mod.EventBusSubscriber
    public static class ServerDecayingItemHandler
    implements DecayingItemHandler {
        public long gameTime;

        @Override
        public long getGameTime() {
            return this.gameTime;
        }

        @Override
        public boolean isClientSide() {
            return false;
        }

        @SubscribeEvent
        public static void onLoadWorld(LevelEvent.Load event) {
            LevelAccessor level = event.getLevel();
            if (!level.m_5776_() && level.m_7654_().m_129783_() == level && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerDecayingItemHandler decayHandler = new ServerDecayingItemHandler();
                decayHandler.gameTime = serverLevel.m_46467_();
                Petrolpark.DECAYING_ITEM_HANDLER.set(decayHandler);
            }
        }
    }
}

