/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.ingredient.modifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.recipe.ingredient.modifier.IngredientModifier;
import com.petrolpark.recipe.ingredient.modifier.IngredientModifierType;
import com.petrolpark.recipe.ingredient.modifier.IngredientModifierTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ContaminatedIngredientModifier
implements IngredientModifier {
    public final ResourceLocation contaminantRL;
    protected Contaminant contaminant = null;

    public ContaminatedIngredientModifier(ResourceLocation contaminantRL) {
        this.contaminantRL = contaminantRL;
    }

    public Optional<Contaminant> getContaminant(Level level) {
        if (this.contaminant == null) {
            this.contaminant = (Contaminant)level.m_9598_().m_175515_(PetrolparkRegistries.Keys.CONTAMINANT).m_7745_(this.contaminantRL);
        }
        if (this.contaminant == null) {
            Petrolpark.LOGGER.warn("Unknown Contaminant: " + this.contaminantRL.toString());
        }
        return Optional.ofNullable(this.contaminant);
    }

    @Override
    public boolean test(ItemStack stack, Level level) {
        return this.getContaminant(level).map(ItemContamination.get(stack)::has).orElse(false);
    }

    @Override
    public void modifyExamples(List<ItemStack> exampleStacks, Level level) {
        this.getContaminant(level).ifPresent(c -> exampleStacks.stream().map(ItemContamination::get).forEach(co -> co.contaminate(this.contaminant)));
    }

    @Override
    public void modifyCounterExamples(List<ItemStack> counterExampleStacks, Level level) {
        this.getContaminant(level).ifPresent(c -> counterExampleStacks.stream().map(ItemContamination::get).forEach(co -> co.decontaminateOnly(this.contaminant)));
    }

    @Override
    public void addToDescription(List<Component> description, Level level) {
        throw new UnsupportedOperationException("Unimplemented method 'addToDescription'");
    }

    @Override
    public IngredientModifierType getType() {
        return (IngredientModifierType)((Object)IngredientModifierTypes.CONTAMINATED.get());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ContaminatedIngredientModifier> {
        public void serialize(JsonObject json, ContaminatedIngredientModifier value, JsonSerializationContext serializationContext) {
            json.addProperty("contaminant", value.contaminantRL.toString());
        }

        public ContaminatedIngredientModifier deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            return new ContaminatedIngredientModifier(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"contaminant")));
        }
    }
}

