/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team.packet;

import com.petrolpark.network.packet.C2SPacket;
import com.petrolpark.team.ITeam;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public abstract class BindTeamPacket
extends C2SPacket {
    public final CompoundTag teamTag;

    public BindTeamPacket(FriendlyByteBuf buffer) {
        this.teamTag = buffer.m_130260_();
    }

    public <T extends ITeam<? super T>> BindTeamPacket(T team) {
        this.teamTag = ITeam.write(team);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.teamTag);
    }

    public abstract <T extends ITeam<? super T>> void handle(T var1, NetworkEvent.Context var2);

    @Override
    public final boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> this.handle(context));
        return true;
    }

    private final <T extends ITeam<? super T>> void handle(NetworkEvent.Context context) {
        ITeam<?> team = ITeam.read(this.teamTag, context.getSender().m_9236_());
        if (team.isMember((Player)context.getSender())) {
            this.handle(team, context);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public <T extends ITeam<? super T>> BindTeamPacket create(T var1);
    }
}

