/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.Petrolpark;
import com.petrolpark.core.badge.Badge;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.data.loot.numberprovider.entity.LootEntityNumberProviderType;
import com.petrolpark.core.data.loot.numberprovider.itemstack.LootItemStackNumberProviderType;
import com.petrolpark.core.data.loot.numberprovider.team.LootTeamNumberProviderType;
import com.petrolpark.core.data.reward.RewardType;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.core.data.reward.generator.RewardGeneratorType;
import com.petrolpark.core.data.reward.team.TeamRewardType;
import com.petrolpark.core.item.decay.product.DecayProductType;
import com.petrolpark.core.recipe.bogglepattern.BogglePattern;
import com.petrolpark.core.recipe.bogglepattern.generator.BogglePatternGeneratorType;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.randomizer.IngredientRandomizerType;
import com.petrolpark.core.scratch.IScratchClass;
import com.petrolpark.core.scratch.symbol.block.IScratchBlock;
import com.petrolpark.core.scratch.symbol.expression.IScratchExpression;
import com.petrolpark.core.shop.Shop;
import com.petrolpark.core.shop.offer.ShopOfferGenerator;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.trade.ITradeListingReference;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PetrolparkRegistries {
    private static final Set<Registry<?>> REGISTRIES = new HashSet(15);
    public static final Registry<DecayProductType> DECAY_PRODUCT_TYPES = PetrolparkRegistries.simple(Keys.DECAY_PRODUCT_TYPE);
    public static final Registry<ITeam.ProviderType> TEAM_PROVIDER_TYPES = PetrolparkRegistries.simple(Keys.TEAM_PROVIDER_TYPE);
    public static final Registry<Badge> BADGES = PetrolparkRegistries.simple(Keys.BADGE);
    public static final Registry<ITradeListingReference.Type> TRADE_LISTING_REFERENCE_TYPES = PetrolparkRegistries.simple(Keys.TRADE_LISTING_REFERENCE_TYPE);
    public static final Registry<IScratchClass<?, ?>> SCRATCH_CLASSES = PetrolparkRegistries.simple(Keys.SCRATCH_CLASS);
    public static final Registry<IScratchBlock.Type<?>> SCRATCH_BLOCK_TYPES = PetrolparkRegistries.simple(Keys.SCRATCH_BLOCK_TYPE);
    public static final Registry<IScratchExpression.Type<?>> SCRATCH_EXPRESSION_TYPES = PetrolparkRegistries.simple(Keys.SCRATCH_EXPRESSION_TYPE);
    public static final Registry<LootItemStackNumberProviderType> LOOT_ITEM_STACK_NUMBER_PROVIDER_TYPES = PetrolparkRegistries.simple(Keys.LOOT_ITEM_STACK_NUMBER_PROVIDER_TYPE);
    public static final Registry<LootEntityNumberProviderType> LOOT_ENTITY_NUMBER_PROVIDER_TYPES = PetrolparkRegistries.simple(Keys.LOOT_ENTITY_NUMBER_PROVIDER_TYPE);
    public static final Registry<LootTeamNumberProviderType> LOOT_TEAM_NUMBER_PROVIDER_TYPES = PetrolparkRegistries.simple(Keys.LOOT_TEAM_NUMBER_PROVIDER_TYPE);
    public static final Registry<IngredientRandomizerType> INGREDIENT_RANDOMIZER_TYPES = PetrolparkRegistries.simple(Keys.INGREDIENT_RANDOMIZER_TYPE);
    public static final Registry<IAdvancedIngredientType<? super ItemStack>> ADVANCED_ITEM_INGREDIENT_TYPES = PetrolparkRegistries.simple(Keys.ADVANCED_ITEM_INGREDIENT_TYPE);
    public static final Registry<IAdvancedIngredientType<? super FluidStack>> ADVANCED_FLUID_INGREDIENT_TYPES = PetrolparkRegistries.simple(Keys.ADVANCED_FLUID_INGREDIENT_TYPE);
    public static final Registry<RewardGeneratorType> REWARD_GENERATOR_TYPES = PetrolparkRegistries.simple(Keys.REWARD_GENERATOR_TYPE);
    public static final Registry<RewardType> REWARD_TYPES = PetrolparkRegistries.simple(Keys.REWARD_TYPE);
    public static final Registry<EntityRewardType> ENTITY_REWARD_TYPES = PetrolparkRegistries.simple(Keys.ENTITY_REWARD_TYPE);
    public static final Registry<TeamRewardType> TEAM_REWARD_TYPES = PetrolparkRegistries.simple(Keys.TEAM_REWARD_TYPE);
    public static final Registry<BogglePatternGeneratorType> BOGGLE_PATTERN_GENERATOR_TYPES = PetrolparkRegistries.simple(Keys.BOGGLE_PATTERN_GENERATOR_TYPE);

    public static final RegistryAccess registryAccess() {
        return (RegistryAccess)Petrolpark.runForDist(() -> () -> {
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                return null;
            }
            return connection.registryAccess();
        }, () -> () -> ServerLifecycleHooks.getCurrentServer().registryAccess());
    }

    public static <OBJECT> Optional<Registry<OBJECT>> getRegistry(ResourceKey<Registry<OBJECT>> key) {
        return PetrolparkRegistries.registryAccess().registry(key);
    }

    public static <OBJECT> Optional<Holder.Reference<OBJECT>> getHolder(ResourceKey<Registry<OBJECT>> registryKey, OBJECT object) {
        return PetrolparkRegistries.getRegistry(registryKey).flatMap(reg -> PetrolparkRegistries.getHolder(reg, object));
    }

    public static <OBJECT> Optional<Holder.Reference<OBJECT>> getHolder(Registry<OBJECT> registry, OBJECT object) {
        ResourceKey key = (ResourceKey)registry.getResourceKey(object).orElseThrow();
        return registry.getHolder(key);
    }

    public static <OBJECT> Optional<Holder.Reference<OBJECT>> getHolder(HolderLookup.Provider provider, ResourceKey<Registry<OBJECT>> registryKey, OBJECT object) {
        if (provider instanceof RegistryAccess) {
            RegistryAccess registryAccess = (RegistryAccess)provider;
            return PetrolparkRegistries.getHolder(registryAccess.registryOrThrow(registryKey), object);
        }
        return provider.lookupOrThrow(registryKey).listElements().filter(h -> h.value() == object).findAny();
    }

    public static <OBJECT> Function<OBJECT, Optional<Holder.Reference<OBJECT>>> holderGetOrThrow(HolderLookup.Provider provider, ResourceKey<Registry<OBJECT>> registryKey) {
        if (provider instanceof RegistryAccess) {
            RegistryAccess registryAccess = (RegistryAccess)provider;
            return object -> PetrolparkRegistries.getHolder(registryAccess.registryOrThrow(registryKey), object);
        }
        return object -> provider.lookupOrThrow(registryKey).listElements().filter(h -> h.value() == object).findAny();
    }

    @ApiStatus.Internal
    public static <T> Registry<T> simple(ResourceKey<Registry<T>> key) {
        return PetrolparkRegistries.register(key, false);
    }

    @ApiStatus.Internal
    public static <T> Registry<T> register(ResourceKey<Registry<T>> key, boolean hasIntrusiveHolders) {
        RegistryBuilder builder = new RegistryBuilder(key).sync(true);
        if (hasIntrusiveHolders) {
            builder.withIntrusiveHolders();
        }
        Registry registry = builder.create();
        REGISTRIES.add(registry);
        return registry;
    }

    @SubscribeEvent
    public static final void onNewRegistries(NewRegistryEvent event) {
        REGISTRIES.forEach(arg_0 -> ((NewRegistryEvent)event).register(arg_0));
    }

    @ApiStatus.Internal
    public static void init() {
    }

    public static class Keys {
        public static final ResourceKey<Registry<Contaminant>> CONTAMINANT = Keys.key("contaminant");
        public static final ResourceKey<Registry<DecayProductType>> DECAY_PRODUCT_TYPE = Keys.key("decay_product_type");
        public static final ResourceKey<Registry<ITeam.ProviderType>> TEAM_PROVIDER_TYPE = Keys.key("team_provider_type");
        public static final ResourceKey<Registry<Badge>> BADGE = Keys.key("badge");
        public static final ResourceKey<Registry<ITradeListingReference.Type>> TRADE_LISTING_REFERENCE_TYPE = Keys.key("trade_listing_reference_type");
        public static final ResourceKey<Registry<IScratchClass<?, ?>>> SCRATCH_CLASS = Keys.key("scratch_class");
        public static final ResourceKey<Registry<IScratchBlock.Type<?>>> SCRATCH_BLOCK_TYPE = Keys.key("scratch_block_type");
        public static final ResourceKey<Registry<IScratchExpression.Type<?>>> SCRATCH_EXPRESSION_TYPE = Keys.key("scratch_expression_type");
        public static final ResourceKey<Registry<LootItemStackNumberProviderType>> LOOT_ITEM_STACK_NUMBER_PROVIDER_TYPE = Keys.key("loot_item_stack_number_provider_type");
        public static final ResourceKey<Registry<LootEntityNumberProviderType>> LOOT_ENTITY_NUMBER_PROVIDER_TYPE = Keys.key("loot_entity_number_provider_type");
        public static final ResourceKey<Registry<LootTeamNumberProviderType>> LOOT_TEAM_NUMBER_PROVIDER_TYPE = Keys.key("loot_team_number_provider_type");
        public static final ResourceKey<Registry<IngredientRandomizerType>> INGREDIENT_RANDOMIZER_TYPE = Keys.key("ingredient_randomizer_type");
        public static final ResourceKey<Registry<IAdvancedIngredientType<? super ItemStack>>> ADVANCED_ITEM_INGREDIENT_TYPE = Keys.key("advanced_ingredient_type");
        public static final ResourceKey<Registry<IAdvancedIngredientType<? super FluidStack>>> ADVANCED_FLUID_INGREDIENT_TYPE = Keys.key("advanced_fluid_ingredient_type");
        public static final ResourceKey<Registry<RewardGeneratorType>> REWARD_GENERATOR_TYPE = Keys.key("reward_generator_type");
        public static final ResourceKey<Registry<RewardType>> REWARD_TYPE = Keys.key("reward_type");
        public static final ResourceKey<Registry<EntityRewardType>> ENTITY_REWARD_TYPE = Keys.key("entity_reward_type");
        public static final ResourceKey<Registry<TeamRewardType>> TEAM_REWARD_TYPE = Keys.key("team_reward_type");
        public static final ResourceKey<Registry<Shop>> SHOP = Keys.key("shop");
        public static final ResourceKey<Registry<ShopOfferGenerator>> SHOP_OFFER_GENERATOR = Keys.key("shop_offer_generator");
        public static final ResourceKey<Registry<BogglePatternGeneratorType>> BOGGLE_PATTERN_GENERATOR_TYPE = Keys.key("boggle_pattern_generator_type");
        public static final ResourceKey<Registry<BogglePattern>> BOGGLE_PATTERN = Keys.key("boggle_pattern");

        private static <T> ResourceKey<Registry<T>> key(String name) {
            return ResourceKey.createRegistryKey((ResourceLocation)Petrolpark.asResource(name));
        }
    }
}

