/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.petrolpark.client.rendering.IGuiTexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import org.joml.Matrix4f;

public class PetrolparkNineSlice {
    public final boolean stretch;
    public final IGuiTexture tex;
    public final int leftColumn;
    public final int rightColumn;
    public final int topRow;
    public final int bottomRow;

    public PetrolparkNineSlice(IGuiTexture tex, int leftColumn, int rightColumn, int topRow, int bottomRow) {
        this.stretch = true;
        this.tex = tex;
        this.leftColumn = leftColumn;
        this.rightColumn = rightColumn;
        this.topRow = topRow;
        this.bottomRow = bottomRow;
    }

    public void render(GuiGraphics graphics, Rect2i rect) {
        this.render(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height) {
        this.renderStretch(graphics, x, y, width, height);
    }

    private void renderStretch(GuiGraphics graphics, int x, int y, int width, int height) {
        this.tex.bind();
        this.drawQuad(graphics, x, x + this.leftColumn, y, y + this.topRow, this.tex.getStartX(), this.tex.getStartX() + this.leftColumn, this.tex.getStartY(), this.tex.getStartY() + this.topRow);
        this.drawQuad(graphics, x, x + this.leftColumn, y + height + this.bottomRow - this.tex.getHeight(), y + height, this.tex.getStartX(), this.tex.getStartX() + this.leftColumn, this.tex.getStartY() + this.bottomRow, this.tex.getStartY() + this.tex.getHeight());
        this.drawQuad(graphics, x + width + this.rightColumn - this.tex.getWidth(), x + width, y, y + this.topRow, this.tex.getStartX() + this.rightColumn, this.tex.getStartX() + this.tex.getWidth(), this.tex.getStartY(), this.tex.getStartY() + this.topRow);
        this.drawQuad(graphics, x + width + this.rightColumn - this.tex.getWidth(), x + width, y + height + this.bottomRow - this.tex.getHeight(), y + height, this.tex.getStartX() + this.rightColumn, this.tex.getStartX() + this.tex.getWidth(), this.tex.getStartY() + this.bottomRow, this.tex.getStartY() + this.tex.getHeight());
        this.drawQuad(graphics, x + this.leftColumn, x + width + this.rightColumn - this.tex.getWidth(), y, y + this.topRow, this.tex.getStartX() + this.leftColumn, this.tex.getStartX() + this.rightColumn, this.tex.getStartY(), this.tex.getStartY() + this.topRow);
        this.drawQuad(graphics, x + this.leftColumn, x + width + this.rightColumn - this.tex.getWidth(), y + height + this.bottomRow - this.tex.getHeight(), y + height, this.tex.getStartX() + this.leftColumn, this.tex.getStartX() + this.rightColumn, this.tex.getStartY() + this.bottomRow, this.tex.getStartY() + this.tex.getHeight());
        this.drawQuad(graphics, x, x + this.leftColumn, y + this.topRow, y + height + this.bottomRow - this.tex.getHeight(), this.tex.getStartX(), this.tex.getStartX() + this.leftColumn, this.tex.getStartY() + this.topRow, this.tex.getStartY() + this.bottomRow);
        this.drawQuad(graphics, x + width + this.rightColumn - this.tex.getWidth(), x + width, y + this.topRow, y + height + this.bottomRow - this.tex.getHeight(), this.tex.getStartX() + this.rightColumn, this.tex.getStartX() + this.tex.getWidth(), this.tex.getStartY() + this.topRow, this.tex.getStartY() + this.bottomRow);
        this.drawQuad(graphics, x + this.leftColumn, x + width + this.rightColumn - this.tex.getWidth(), y + this.topRow, y + height + this.bottomRow - this.tex.getHeight(), this.tex.getStartX() + this.leftColumn, this.tex.getStartX() + this.rightColumn, this.tex.getStartY() + this.topRow, this.tex.getStartY() + this.bottomRow);
    }

    private void drawQuad(GuiGraphics graphics, int left, int right, int top, int bottom, int u1, int u2, int v1, int v2) {
        PetrolparkNineSlice.drawTexturedQuad(graphics.pose().last().pose(), 255, 255, 255, 255, left, right, top, bottom, 0, (float)u1 / (float)this.tex.getTextureWidth(), (float)u2 / (float)this.tex.getTextureWidth(), (float)v1 / (float)this.tex.getTextureHeight(), (float)v2 / (float)this.tex.getTextureHeight());
    }

    private static void drawTexturedQuad(Matrix4f m, int r, int g, int b, int alpha, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        bufferbuilder.addVertex(m, (float)left, (float)bot, (float)z).setColor(r, g, b, alpha).setUv(u1, v2);
        bufferbuilder.addVertex(m, (float)right, (float)bot, (float)z).setColor(r, g, b, alpha).setUv(u2, v2);
        bufferbuilder.addVertex(m, (float)right, (float)top, (float)z).setColor(r, g, b, alpha).setUv(u2, v1);
        bufferbuilder.addVertex(m, (float)left, (float)top, (float)z).setColor(r, g, b, alpha).setUv(u1, v1);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

