/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.SharedFeatureFlag;
import com.petrolpark.compat.create.CreateBlocks;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrusionRecipe;
import com.petrolpark.compat.jei.category.AgeingCategory;
import com.petrolpark.compat.jei.category.DecayingItemCategory;
import com.petrolpark.compat.jei.category.ExtrusionCategory;
import com.petrolpark.compat.jei.category.LiddedBasinCategory;
import com.petrolpark.compat.jei.category.ManualOnlyCategory;
import com.petrolpark.compat.jei.category.builder.PetrolparkCategoryBuilder;
import com.petrolpark.compat.jei.ingredient.BiomeIngredientType;
import com.petrolpark.core.item.decay.ageing.AgeingRecipe;
import com.petrolpark.core.recipe.crafting.ManualOnlyCraftingRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@RequiresCreate
public class PetrolparkCreateJEI
implements IModPlugin {
    private static final List<CreateRecipeCategory<?>> ALL_CATEGORIES = new ArrayList(2);
    int itemDecayRecipeCount = 0;

    private void loadCategories(IJeiHelpers helpers) {
        ALL_CATEGORIES.clear();
        CreateRecipeCategory ageing = ((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)this.builder(AgeingRecipe.class).addTypedRecipes(() -> PetrolparkRecipeTypes.AGEING.get())).catalyst(() -> Items.BARREL)).itemIcon((ItemLike)Items.BARREL)).emptyBackground(125, 20)).build("ageing", AgeingCategory::new);
        CreateRecipeCategory manual_crafting = ((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)this.builder(CraftingRecipe.class).addTypedRecipesIf(() -> RecipeType.CRAFTING, rh -> rh.value() instanceof ManualOnlyCraftingRecipe)).catalyst(() -> Blocks.CRAFTING_TABLE)).doubleItemIcon(() -> new ItemStack((ItemLike)Items.CRAFTING_TABLE), () -> {
            Minecraft mc = Minecraft.getInstance();
            ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            if (mc.player != null) {
                head.set(DataComponents.PROFILE, (Object)new ResolvableProfile(mc.player.getGameProfile()));
            }
            return head;
        })).emptyBackground(116, 56)).build("manual_crafting", ManualOnlyCategory::new);
        CreateRecipeCategory item_decay = ((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)this.builder(DecayingItemCategory.DecayingItemRecipe.class).addRecipes(helpers.getIngredientManager().getAllItemStacks().stream().map(DecayingItemCategory::createRecipe).filter(Optional::isPresent).map(Optional::get).map(r -> new RecipeHolder(Petrolpark.asResource("decay_" + this.itemDecayRecipeCount++), (Recipe)r))::toList)).itemIcon((ItemLike)Items.ROTTEN_FLESH)).emptyBackground(125, 20)).build("item_decay", DecayingItemCategory::new);
        if (SharedFeatureFlag.BASIN_LID.enabled()) {
            CreateRecipeCategory createRecipeCategory = ((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)this.builder(BasinRecipe.class).addTypedRecipes(CreateRecipeTypes.LIDDED_BASIN)).catalyst(() -> CreateBlocks.BASIN_LID.get())).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get())).doubleItemIcon((ItemLike)CreateBlocks.BASIN_LID.get(), (ItemLike)AllBlocks.BASIN.get())).emptyBackground(177, 103)).build("lidded_basin", LiddedBasinCategory::new);
        }
        if (SharedFeatureFlag.EXTRUSION.enabled()) {
            CreateRecipeCategory createRecipeCategory = ((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)((CategoryBuilderImpl)this.builder(ExtrusionRecipe.class).addTypedRecipes(CreateRecipeTypes.EXTRUSION)).catalyst(() -> CreateBlocks.EXTRUSION_DIE.get())).itemIcon((ItemLike)CreateBlocks.EXTRUSION_DIE.get())).emptyBackground(177, 55)).build("extrusion", ExtrusionCategory::new);
        }
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        this.loadCategories(registration.getJeiHelpers());
        PetrolparkCategoryBuilder.helpers = registration.getJeiHelpers();
        registration.addRecipeCategories((IRecipeCategory[])ALL_CATEGORIES.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ALL_CATEGORIES.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        ALL_CATEGORIES.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registration) {
        registration.register((IIngredientType)BiomeIngredientType.TYPE, Collections.emptySet(), (IIngredientHelper)BiomeIngredientType.HELPER, (IIngredientRenderer)BiomeIngredientType.RENDERER, BiomeIngredientType.HELPER.getRegistry().byNameCodec());
    }

    private <T extends Recipe<?>> CategoryBuilderImpl<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilderImpl<T>(recipeClass);
    }

    public ResourceLocation getPluginUid() {
        return Petrolpark.asResource("create_jei");
    }

    private static class CategoryBuilderImpl<R extends Recipe<?>>
    extends PetrolparkCategoryBuilder<R, CategoryBuilderImpl<R>> {
        public CategoryBuilderImpl(Class<? extends R> recipeClass) {
            super("petrolpark", recipeClass, ALL_CATEGORIES::add);
        }
    }
}

