/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.petrolpark.core.codec.ContextualFieldDecoder;
import com.petrolpark.core.codec.ContextualMapDecoder;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface ContextualDecoder<CONTEXT, A> {
    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var1, CONTEXT var2, T var3);

    default public <T> DataResult<A> parse(DynamicOps<T> ops, CONTEXT context, T input) {
        return this.decode(ops, context, input).map(Pair::getFirst);
    }

    default public <T> DataResult<Pair<A, T>> decode(CONTEXT context, Dynamic<T> input) {
        return this.decode(input.getOps(), context, input.getValue());
    }

    default public <T> DataResult<A> parse(CONTEXT context, Dynamic<T> input) {
        return this.decode(context, input).map(Pair::getFirst);
    }

    default public ContextualMapDecoder<CONTEXT, A> fieldOf(String name) {
        return new ContextualFieldDecoder(name, this);
    }

    default public <B> ContextualDecoder<CONTEXT, B> map(final Function<? super A, ? extends B> function) {
        return new ContextualDecoder<CONTEXT, B>(){

            @Override
            public <T> DataResult<Pair<B, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
                return ContextualDecoder.this.decode(ops, context, input).map(p -> p.mapFirst(function));
            }

            public String toString() {
                return ContextualDecoder.this.toString() + "[mapped]";
            }
        };
    }

    default public <B> ContextualDecoder<CONTEXT, B> flatContextualMap(final BiFunction<CONTEXT, ? super A, ? extends DataResult<? extends B>> function) {
        return new ContextualDecoder<CONTEXT, B>(){

            @Override
            public <T> DataResult<Pair<B, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
                return ContextualDecoder.this.decode(ops, context, input).flatMap(p -> ((DataResult)function.apply(context, p.getFirst())).map(r -> Pair.of((Object)r, (Object)p.getSecond())));
            }

            public String toString() {
                return ContextualDecoder.this.toString() + "[flatMapped]";
            }
        };
    }
}

