/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.reward.entity.AbstractGiveItemsEntityReward;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.util.Lang;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class GiveItemEntityReward
extends AbstractGiveItemsEntityReward {
    public static final MapCodec<GiveItemEntityReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(GiveItemEntityReward::getStack)).and(GiveItemEntityReward.lateItemFunctionsField(instance).t1()).apply((Applicative)instance, GiveItemEntityReward::new));
    protected final ItemStack stack;

    public GiveItemEntityReward(ItemStack stack, List<LootItemFunction> functions) {
        super(functions);
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public Stream<ItemStack> streamStacks(Entity recipient, LootContext context) {
        return Stream.of(this.stack);
    }

    @Override
    public void render(GuiGraphics graphics) {
        graphics.renderItem(this.stack, 0, 0);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add(this.translateSimple(this.stack.getDisplayName()));
    }

    @Override
    public EntityRewardType getType() {
        return (EntityRewardType)PetrolparkRewardTypes.GIVE_ITEM.get();
    }
}

