/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay.ageing;

import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.item.decay.ItemDecay;
import com.petrolpark.core.item.decay.ageing.AgeingRecipe;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;

public interface AgeingContainerWrapper
extends Container {
    public static boolean ageingInVanillaBarrelsEnabled() {
        return (Boolean)PetrolparkConfigs.server().ageingInVanillaBarrels.get();
    }

    public static boolean isAgeingContainer(Container container) {
        if (container instanceof AgeingContainerWrapper) {
            return true;
        }
        return container instanceof BarrelBlockEntity && AgeingContainerWrapper.ageingInVanillaBarrelsEnabled();
    }

    public static ItemStack getItem(Level level, GetItem getItem, int slot) {
        return AgeingContainerWrapper.checkDecay(level, getItem.getItem(slot));
    }

    public static ItemStack removeItem(Level level, RemoveItem removeItem, int slot, int amount) {
        return AgeingContainerWrapper.withAgeingDecayRemoved(level, removeItem.removeItem(slot, amount));
    }

    public static ItemStack removeItemNoUpdate(Level level, RemoveItemNoUpdate removeItemNoUpdate, int slot) {
        return AgeingContainerWrapper.withAgeingDecayRemoved(level, removeItemNoUpdate.removeItemNoUpdate(slot));
    }

    public static void setItem(Level level, SetItem setItem, int slot, @Nonnull ItemStack stack) {
        setItem.setItem(slot, AgeingContainerWrapper.withAgeingDecay(level, ItemDecay.checkDecay(stack), true));
    }

    public static ItemStack withAgeingDecayRemoved(Level level, ItemStack stack) {
        level.getRecipeManager().getRecipesFor((RecipeType)PetrolparkRecipeTypes.AGEING.get(), (RecipeInput)new SingleRecipeInput(stack), level).stream().findAny().ifPresent(rh -> ItemDecay.removeAppliedDecay(stack));
        return AgeingContainerWrapper.checkDecay(level, stack);
    }

    public static ItemStack withAgeingDecay(Level level, ItemStack stack, boolean startDecay) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return AgeingContainerWrapper.checkDecay(level, level.getRecipeManager().getRecipesFor((RecipeType)PetrolparkRecipeTypes.AGEING.get(), (RecipeInput)input, level).stream().findAny().map(RecipeHolder::value).map(AgeingRecipe::cast).map(recipe -> recipe.assemble(input, startDecay)).orElse(stack));
    }

    public static ItemStack checkDecay(Level level, ItemStack stack) {
        return ItemDecay.checkDecay(stack, s -> AgeingContainerWrapper.withAgeingDecay(level, s, false));
    }

    public Container getWrappedContainer();

    public Level getLevel();

    default public void clearContent() {
        this.getWrappedContainer().clearContent();
    }

    default public int getContainerSize() {
        return this.getWrappedContainer().getContainerSize();
    }

    default public boolean isEmpty() {
        return this.getWrappedContainer().isEmpty();
    }

    default public ItemStack getItem(int slot) {
        return AgeingContainerWrapper.getItem(this.getLevel(), arg_0 -> ((Container)this.getWrappedContainer()).getItem(arg_0), slot);
    }

    default public ItemStack removeItem(int slot, int amount) {
        return AgeingContainerWrapper.removeItem(this.getLevel(), (arg_0, arg_1) -> ((Container)this.getWrappedContainer()).removeItem(arg_0, arg_1), slot, amount);
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return AgeingContainerWrapper.removeItemNoUpdate(this.getLevel(), arg_0 -> ((Container)this.getWrappedContainer()).removeItemNoUpdate(arg_0), slot);
    }

    default public void setItem(int slot, @Nonnull ItemStack stack) {
        AgeingContainerWrapper.setItem(this.getLevel(), (arg_0, arg_1) -> ((Container)this.getWrappedContainer()).setItem(arg_0, arg_1), slot, stack);
    }

    @FunctionalInterface
    public static interface GetItem {
        public ItemStack getItem(int var1);
    }

    @FunctionalInterface
    public static interface RemoveItem {
        public ItemStack removeItem(int var1, int var2);
    }

    @FunctionalInterface
    public static interface RemoveItemNoUpdate {
        public ItemStack removeItemNoUpdate(int var1);
    }

    @FunctionalInterface
    public static interface SetItem {
        public void setItem(int var1, @Nonnull ItemStack var2);
    }
}

