/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ITypelessAdvancedIngredient;
import com.petrolpark.util.Lang;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public record TypeAttachedAdvancedIngredient<STACK, INGREDIENT extends ITypelessAdvancedIngredient<? super STACK>>(INGREDIENT untypedIngredient, IAdvancedIngredientType<STACK> type) implements IAdvancedIngredient<STACK>,
IForcingItemAdvancedIngredient
{
    @Override
    public boolean test(STACK stack) {
        return this.untypedIngredient().test(stack);
    }

    @Override
    public Stream<STACK> modifyExamples(Stream<STACK> exampleStacks) {
        return this.untypedIngredient().modifyExamples(exampleStacks.map(this::checkedCast)).map(this::checkedCast);
    }

    @Override
    public Stream<STACK> modifyCounterExamples(Stream<STACK> counterExampleStacks) {
        return this.untypedIngredient().modifyCounterExamples(counterExampleStacks.map(this::checkedCast)).map(this::checkedCast);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        this.untypedIngredient().addToDescription(description);
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        this.untypedIngredient().addToCounterDescription(description);
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        INGREDIENT INGREDIENT = this.untypedIngredient();
        if (INGREDIENT instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)INGREDIENT;
            return functionForcingIngredient.forceLootItemFunction(function, context, stack);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        INGREDIENT INGREDIENT = this.untypedIngredient();
        if (INGREDIENT instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)INGREDIENT;
            return functionForcingIngredient.forbidLootItemFunction(function, context, stack);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        INGREDIENT INGREDIENT = this.untypedIngredient();
        if (INGREDIENT instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)INGREDIENT;
            return functionForcingIngredient.forceTradeListing(tradeListing, trader, random);
        }
        return null;
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        INGREDIENT INGREDIENT = this.untypedIngredient();
        if (INGREDIENT instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)INGREDIENT;
            return functionForcingIngredient.forbidTradeListing(tradeListing, trader, random);
        }
        return null;
    }

    @Override
    public IAdvancedIngredientType<? super STACK> getType() {
        return this.type();
    }

    @Override
    public IAdvancedIngredient<? super STACK> simplify() {
        ITypelessAdvancedIngredient simplifiedUntypedIngredient = this.untypedIngredient().simplify();
        if (simplifiedUntypedIngredient == this.untypedIngredient()) {
            return this;
        }
        return new TypeAttachedAdvancedIngredient(simplifiedUntypedIngredient, this.type());
    }
}

