/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.recycling;

import com.petrolpark.core.recipe.recycling.RecyclingOutput;
import com.petrolpark.util.BigItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class RecyclingOutputs
extends LinkedList<RecyclingOutput> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecyclingOutputs> STREAM_CODEC = StreamCodec.composite((StreamCodec)RecyclingOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), output -> output, (StreamCodec)ByteBufCodecs.DOUBLE, RecyclingOutputs::getExpectationMultiplier, (list, multiplier) -> new RecyclingOutputs((Collection<RecyclingOutput>)list).multiplyAll((double)multiplier));
    public double expectationMultiplier = 1.0;

    public static final RecyclingOutputs empty() {
        return new RecyclingOutputs((Collection<RecyclingOutput>)Collections.emptyList());
    }

    public RecyclingOutputs(ItemStack stack) {
        this((Collection<RecyclingOutput>)Collections.singleton(new RecyclingOutput(stack)));
    }

    public RecyclingOutputs(Collection<RecyclingOutput> outputs) {
        super(outputs);
    }

    public double getExpectationMultiplier() {
        return this.expectationMultiplier;
    }

    @Override
    public void add(int index, RecyclingOutput output) {
        this.add(output);
    }

    @Override
    public boolean add(RecyclingOutput newOutput) {
        int i = 0;
        for (RecyclingOutput output : this) {
            if (ItemStack.isSameItemSameComponents((ItemStack)output.getItem(), (ItemStack)newOutput.getItem())) {
                output.expectedCount += newOutput.expectedCount;
                return true;
            }
            if (newOutput.compareTo(output) < 0) break;
            ++i;
        }
        super.add(i, newOutput);
        return true;
    }

    public RecyclingOutputs addOther(RecyclingOutputs outputs) {
        this.addAll(outputs);
        return this;
    }

    @Override
    public boolean addAll(Collection<? extends RecyclingOutput> collection) {
        if (collection instanceof RecyclingOutputs) {
            RecyclingOutputs outputs = (RecyclingOutputs)collection;
            outputs.forEach(output -> this.add(output.copy().multiply(outputs.getExpectationMultiplier())));
            return true;
        }
        return super.addAll(collection);
    }

    public RecyclingOutputs multiplyAll(double factor) {
        this.expectationMultiplier *= factor;
        return this;
    }

    public void splitAll(double proportion, Consumer<RecyclingOutput> modification) {
        this.splitAll(proportion, modification, o -> {});
    }

    public void splitAll(double proportion, Consumer<RecyclingOutput> modification, Consumer<RecyclingOutput> remainderModification) {
        ArrayList<RecyclingOutput> existingOutputs = new ArrayList<RecyclingOutput>(this);
        for (RecyclingOutput existing : existingOutputs) {
            RecyclingOutput split = existing.copy().multiply(proportion);
            modification.accept(split);
            this.add(split);
            existing.multiply(1.0 - proportion);
            remainderModification.accept(existing);
        }
    }

    public List<ItemStack> rollStacks(RandomSource randomSource) {
        return this.stream().map(output -> output.rollStack(this.expectationMultiplier, randomSource)).map(BigItemStack::getAsStacks).flatMap(Collection::stream).toList();
    }

    public RecyclingOutputs copy() {
        return new RecyclingOutputs(this).multiplyAll(this.expectationMultiplier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RecyclingOutputs)) return false;
        RecyclingOutputs outputs = (RecyclingOutputs)o;
        if (this.expectationMultiplier != outputs.expectationMultiplier) return false;
        if (!super.equals(outputs)) return false;
        return true;
    }
}

