/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.petrolpark.common.mobeffect.shader.ClientEffectHandler;
import com.petrolpark.common.mobeffect.shader.IShaderEffect;
import com.petrolpark.common.mobeffect.shader.packet.InitEffectShaderPacket;
import com.petrolpark.common.mobeffect.shader.packet.SyncMobEffectTotalDurationPacket;
import com.petrolpark.util.mixininterfaces.IMobEffectInstanceMixin;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MobEffectInstance.class})
public abstract class MobEffectInstanceMixin
implements IMobEffectInstanceMixin,
Comparable<MobEffectInstance> {
    private static final String TOTAL_DURATION_TAG_KEY = "TotalDuration";
    @Shadow
    private int duration;
    @Final
    @Shadow
    private Holder<MobEffect> effect;
    @Unique
    private int petrolpark$totalDuration;

    @Shadow
    public abstract boolean isInfiniteDuration();

    @Inject(method={"<init>(Lnet/minecraft/core/Holder;IIZZZLnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="RETURN")})
    private void onInitialize(CallbackInfo ignored) {
        this.petrolpark$totalDuration = this.duration;
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="TAIL")})
    private void inEffectAdded(LivingEntity entity, CallbackInfo ignored) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncMobEffectTotalDurationPacket(this.petrolpark$totalDuration, this.effect), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.effect.value() instanceof IShaderEffect) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InitEffectShaderPacket(this.effect), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @ModifyReturnValue(method={"save"}, at={@At(value="RETURN")})
    private Tag modifySaveData(Tag original) {
        CompoundTag nbt = (CompoundTag)original;
        nbt.putInt(TOTAL_DURATION_TAG_KEY, this.petrolpark$getTotalDuration());
        return nbt;
    }

    @ModifyReturnValue(method={"load"}, at={@At(value="RETURN")})
    private static MobEffectInstance modifyLoadData(MobEffectInstance original, CompoundTag nbt) {
        if (original != null) {
            ((IMobEffectInstanceMixin)original).petrolpark$setTotalDuration(nbt.getInt(TOTAL_DURATION_TAG_KEY));
        }
        return original;
    }

    @Inject(method={"update"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void inUpdate(MobEffectInstance other, CallbackInfoReturnable<Boolean> cir, boolean flag) {
        if (flag) {
            if (this.isInfiniteDuration()) {
                return;
            }
            if (other.isInfiniteDuration()) {
                this.petrolpark$setTotalDuration(-1);
            } else {
                this.petrolpark$setTotalDuration(this.petrolpark$getTotalDuration() - this.duration + ((IMobEffectInstanceMixin)other).petrolpark$getTotalDuration());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void petrolpark$updateUniforms() {
        float value = this.duration >= 0 && this.petrolpark$totalDuration > 0 ? (float)this.duration / (float)this.petrolpark$totalDuration : 0.5f;
        ClientEffectHandler.updateUniforms(value);
    }

    @Override
    public void petrolpark$setTotalDuration(int totalDuration) {
        this.petrolpark$totalDuration = totalDuration;
    }

    @Override
    public int petrolpark$getTotalDuration() {
        return this.petrolpark$totalDuration;
    }
}

