/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.world.item.ItemStack;

public class DataComponentHelper {
    public static final boolean equalIgnoring(DataComponentMap map1, DataComponentMap map2, Predicate<DataComponentType<?>> ignoredTypes) {
        if (map1.equals((Object)map2)) {
            return true;
        }
        HashSet<DataComponentType> checkedTypes = new HashSet<DataComponentType>(map1.size());
        for (TypedDataComponent component : map1) {
            checkedTypes.add(component.type());
            if (ignoredTypes.test(component.type()) || Objects.equals(component, map2.get(component.type()))) continue;
            return false;
        }
        for (TypedDataComponent component : map2) {
            if (checkedTypes.contains(component.type()) || ignoredTypes.test(component.type()) || Objects.equals(map2.get(component.type()), component)) continue;
            return false;
        }
        return true;
    }

    public static final <T> void revert(ItemStack stack, DataComponentType<T> componentType) {
        stack.set(componentType, stack.getPrototype().get(componentType));
    }
}

