/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class GraphHelper {
    public static <T> Set<T> getAllDescendants(T parent, Function<T, ? extends Iterable<? extends T>> childGetter) throws CircularReferenceException {
        return GraphHelper.getAllDescendants(parent, childGetter, obj -> false);
    }

    public static <T> Set<T> getAllDescendants(T parent, Function<T, ? extends Iterable<? extends T>> childGetter, Predicate<T> noChildren) throws CircularReferenceException {
        HashSet descendants = new HashSet();
        LinkedList toAdd = new LinkedList();
        childGetter.apply(parent).forEach(toAdd::add);
        while (!toAdd.isEmpty()) {
            Object child = toAdd.poll();
            if (child == parent) {
                throw new CircularReferenceException();
            }
            if (!(descendants.add(child) & !noChildren.test(child))) continue;
            childGetter.apply(child).forEach(toAdd::add);
        }
        return descendants;
    }

    public static class CircularReferenceException
    extends Exception {
    }
}

