/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.shop;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.network.GsonSerializableCodecs;
import com.petrolpark.shop.offer.ShopOffer;
import com.petrolpark.shop.offer.ShopOfferGenerator;
import com.petrolpark.shop.offer.ShopOrderModifierEntry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Shop {
    public static final Codec<Shop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Shop::getTranslationKey), (App)Codec.list(OfferGeneratorEntry.CODEC).fieldOf("offerGenerators").forGetter(Shop::getOfferGeneratorEntries), (App)Codec.list(ShopOrderModifierEntry.CODEC).optionalFieldOf("globalOrderModifiers", Collections.emptyList()).forGetter(Shop::getGlobalOrderModifierEntries), (App)TagKey.m_203877_((ResourceKey)Registries.f_256939_).optionalFieldOf("customerEntityTypes").forGetter(Shop::getCustomerEntityTypes)).apply((Applicative)instance, Shop::new));
    protected final String translationKey;
    public final List<OfferGeneratorEntry> offerGeneratorEntries;
    protected final List<ShopOrderModifierEntry> globalOrderModifierEntries;
    public final Optional<TagKey<EntityType<?>>> customerEntityTypes;

    public Shop(String translationKey, List<OfferGeneratorEntry> offerGeneratorEntries, List<ShopOrderModifierEntry> globalOrderModifierEntries, Optional<TagKey<EntityType<?>>> customerEntityTypes) {
        this.translationKey = translationKey;
        this.offerGeneratorEntries = offerGeneratorEntries;
        this.globalOrderModifierEntries = globalOrderModifierEntries;
        this.customerEntityTypes = customerEntityTypes;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public List<OfferGeneratorEntry> getOfferGeneratorEntries() {
        return this.offerGeneratorEntries;
    }

    public List<ShopOrderModifierEntry> getGlobalOrderModifierEntries() {
        return this.globalOrderModifierEntries;
    }

    public Optional<TagKey<EntityType<?>>> getCustomerEntityTypes() {
        return this.customerEntityTypes;
    }

    public ShopOffer generateOffer(LootContext context) {
        float totalWeight = 0.0f;
        float[] weights = new float[this.offerGeneratorEntries.size()];
        for (int i = 0; i < this.offerGeneratorEntries.size(); ++i) {
            OfferGeneratorEntry generator = this.offerGeneratorEntries.get(i);
            weights[i] = totalWeight;
            totalWeight += generator.weight.m_142688_(context);
        }
        float roll = context.m_230907_().m_188501_() * totalWeight;
        for (int i = 0; i < this.offerGeneratorEntries.size(); ++i) {
            if (!(roll > weights[i])) continue;
            return this.offerGeneratorEntries.get((int)i).generator.generate(context, this);
        }
        return ShopOffer.EMPTY;
    }

    public boolean canServe(Entity entity) {
        return this.customerEntityTypes.map(arg_0 -> ((EntityType)entity.m_6095_()).m_204039_(arg_0)).orElse(false);
    }

    public record OfferGeneratorEntry(ShopOfferGenerator generator, NumberProvider weight) implements LootContextUser
    {
        public static final Codec<OfferGeneratorEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ShopOfferGenerator.CODEC.fieldOf("generator").forGetter(OfferGeneratorEntry::generator), (App)GsonSerializableCodecs.NUMBER_PROVIDER.fieldOf("weight").forGetter(OfferGeneratorEntry::weight)).apply((Applicative)instance, OfferGeneratorEntry::new));

        public Set<LootContextParam<?>> m_6231_() {
            return Sets.union((Set)this.generator.m_6231_(), (Set)this.weight.m_6231_());
        }
    }
}

