/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.team.NoTeam;
import com.petrolpark.team.TeamTypes;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.util.Lang;
import com.petrolpark.util.NBTHelper;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ITeam<T extends ITeam<? super T>> {
    public static ITeam<?> read(CompoundTag tag, Level level) {
        ITeamType<?> type = NBTHelper.readRegistryObject(tag, "Type", PetrolparkRegistries.Keys.TEAM_TYPE);
        if (type == null) {
            Petrolpark.LOGGER.warn("Unknown Team Type: " + tag.m_128461_("Type"));
            return NoTeam.INSTANCE;
        }
        return type.read(tag, level);
    }

    public static <T extends ITeam<? super T>> CompoundTag write(T team) {
        CompoundTag tag = new CompoundTag();
        NBTHelper.writeRegistryObject(tag, "Type", PetrolparkRegistries.Keys.TEAM_TYPE, team.getType());
        team.getType().write(team, tag);
        return tag;
    }

    public ITeamType<T> getType();

    default public boolean isNone() {
        return this.getType() == TeamTypes.NONE;
    }

    public boolean isMember(Player var1);

    public Stream<String> streamMemberUsernames(Level var1);

    public boolean isAdmin(Player var1);

    public Component getName(Level var1);

    @Nonnull
    public <DATA> DATA getTeamData(ITeamDataType<? super DATA> var1);

    public void setChanged(Level var1, ITeamDataType<?> var2);

    @OnlyIn(value=Dist.CLIENT)
    public void renderIcon(GuiGraphics var1);

    @OnlyIn(value=Dist.CLIENT)
    default public Component getRenderedMemberList(int maxTextWidth) {
        Minecraft mc = Minecraft.m_91087_();
        return Lang.shortList(this.streamMemberUsernames((Level)mc.f_91073_).map(Component::m_237113_).toList(), maxTextWidth, mc.f_91062_);
    }

    public static interface ITeamType<T extends ITeam<? super T>> {
        public T read(CompoundTag var1, Level var2);

        public void write(T var1, CompoundTag var2);
    }
}

