/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.item.decay;

import com.petrolpark.Petrolpark;
import com.petrolpark.item.decay.DecayingItemRenderer;
import com.petrolpark.item.decay.IDecayingItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class DecayingItem
extends Item
implements IDecayingItem {
    public DecayingItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        long displayedSecondsRemaining;
        super.m_7373_(stack, pLevel, tooltip, pIsAdvanced);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("CreationTime", 4)) {
            long ticksRemaining = IDecayingItem.getRemainingTime(this, stack, tag);
            displayedSecondsRemaining = ticksRemaining / 20L;
        } else {
            displayedSecondsRemaining = this.getLifetime(stack) / 20L;
        }
        if (displayedSecondsRemaining < 0L) {
            displayedSecondsRemaining = 0L;
        }
        tooltip.add((Component)Component.m_237110_((String)this.getDecayTimeTranslationKey(stack), (Object[])new Object[]{String.format("%02d:%02d", displayedSecondsRemaining / 60L, displayedSecondsRemaining % 60L)}).m_6881_().m_130940_(ChatFormatting.GRAY));
    }

    public void m_7836_(ItemStack stack, Level pLevel, Player pPlayer) {
        IDecayingItem.startDecay(stack, 0L);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        ItemStack trueStack = IDecayingItem.checkDecay(stack);
        ItemStack otherTrueStack = IDecayingItem.checkDecay(other);
        if (stack == trueStack && other == otherTrueStack && stack.m_150930_(other.m_41720_()) && stack.m_41782_() && other.m_41782_() && this.areDecayTimesCombineable(stack, other)) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag otherTag = other.m_41784_();
            if (tag.m_128425_("CreationTime", 4) && otherTag.m_128425_("CreationTime", 4)) {
                int transferred = action == ClickAction.PRIMARY ? Math.min(stack.m_41741_() - stack.m_41613_(), other.m_41613_()) : 1;
                long totalTime = (long)stack.m_41613_() * IDecayingItem.getRemainingTime(this, stack, tag) + (long)transferred * IDecayingItem.getRemainingTime(this, other, otherTag);
                stack.m_41769_(transferred);
                tag.m_128356_("CreationTime", Petrolpark.DECAYING_ITEM_HANDLER.get().getGameTime() + totalTime / (long)stack.m_41613_() - this.getLifetime(stack));
                other.m_41774_(transferred);
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new DecayingItemRenderer()));
    }
}

