/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.compat.create;

import com.petrolpark.PetrolparkConfig;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.item.decay.IDecayingItem;
import com.petrolpark.recipe.advancedprocessing.firsttimelucky.FirstTimeLuckyRecipesBehaviour;
import com.petrolpark.recipe.advancedprocessing.firsttimelucky.IFirstTimeLuckyRecipe;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.millstone.MillingRecipe;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MillstoneBlockEntity.class}, remap=false)
public abstract class MillstoneBlockEntityMixin
extends KineticBlockEntity {
    @Unique
    ItemStack lastItemProcessed;
    @Shadow
    private MillingRecipe lastRecipe;
    @Shadow
    public ItemStackHandler inputInv;
    @Shadow
    public ItemStackHandler outputInv;

    public MillstoneBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        throw new AssertionError();
    }

    @Inject(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;addBehaviours(Ljava/util/List;)V"}, at={@At(value="RETURN")}, remap=false)
    public void inAddBehaviours(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        behaviours.add(new FirstTimeLuckyRecipesBehaviour((SmartBlockEntity)this, r -> r.m_6671_() == AllRecipeTypes.MILLING.getType()));
    }

    @Inject(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;process()V"}, at={@At(value="HEAD")}, remap=false)
    public void inProcessStart(CallbackInfo ci) {
        this.lastItemProcessed = this.inputInv.getStackInSlot(0).m_41777_();
    }

    @Inject(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;process()V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/millstone/MillingRecipe;rollResults()Ljava/util/List;")}, cancellable=true, remap=false)
    public void inProcessEnd(CallbackInfo ci) {
        List<ItemStack> results;
        MillingRecipe millingRecipe;
        FirstTimeLuckyRecipesBehaviour behaviour = (FirstTimeLuckyRecipesBehaviour)this.getBehaviour(FirstTimeLuckyRecipesBehaviour.TYPE);
        if (behaviour != null && (millingRecipe = this.lastRecipe) instanceof IFirstTimeLuckyRecipe) {
            IFirstTimeLuckyRecipe ftlr = (IFirstTimeLuckyRecipe)millingRecipe;
            results = ftlr.rollLuckyResults(behaviour.getPlayer());
        } else {
            results = this.lastRecipe.rollResults();
        }
        if (((Boolean)PetrolparkConfig.SERVER.createCrushingRecipesPropagateContaminants.get()).booleanValue() && this.lastItemProcessed != null) {
            IContamination<?, ?> inputContamination = ItemContamination.get(this.lastItemProcessed);
            results.stream().map(ItemContamination::get).forEach(c -> c.contaminateAll(inputContamination.streamAllContaminants()));
        }
        results.forEach(stack -> {
            IDecayingItem.startDecay(stack);
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false);
        });
        this.award(AllAdvancements.MILLSTONE);
        this.notifyUpdate();
        ci.cancel();
    }
}

