/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team;

import com.petrolpark.team.GatherTeamsEvent;
import com.petrolpark.team.ITeam;
import com.petrolpark.team.NoTeam;
import com.petrolpark.team.SelectTeamScreen;
import com.petrolpark.team.packet.BindTeamItemPacket;
import com.petrolpark.util.ScreenHelper;
import java.util.List;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;

public interface ITeamBoundItem<I extends Item> {
    public static final String TEAM_TAG_KEY = "Team";

    public boolean isTeamRebindable(Level var1, Player var2, ItemStack var3);

    @OnlyIn(value=Dist.CLIENT)
    public Component getTeamSelectionScreenTitle(Level var1, Player var2, ItemStack var3);

    default public InteractionResult trySelectTeam(ItemStack stack, Player player, Level level) {
        if (!ITeamBoundItem.getTeam(stack, level).isNone() && !this.isTeamRebindable(level, player, stack)) {
            return InteractionResult.PASS;
        }
        GatherTeamsEvent event = new GatherTeamsEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getTeamsUnmodifiable().size() == 1) {
            this.bind(event.getTeamsUnmodifiable().get(0), stack, player);
        } else if (level.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ITeamBoundItem.openScreen(this.getTeamSelectionScreenTitle(level, player, stack), event.getTeamsUnmodifiable()));
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openScreen(Component title, List<ITeam<?>> teams) {
        ScreenHelper.openScreen(new SelectTeamScreen(title, teams, BindTeamItemPacket::new));
    }

    public static ITeam<?> getTeam(ItemStack stack, Level level) {
        if (!(stack.m_41720_() instanceof ITeamBoundItem && stack.m_41782_() && stack.m_41783_().m_128425_(TEAM_TAG_KEY, 10))) {
            return NoTeam.INSTANCE;
        }
        return ITeam.read(stack.m_41698_(TEAM_TAG_KEY), level);
    }

    default public <T extends ITeam<? super T>> void bind(ITeam<?> team, ItemStack stack, Player player) {
        if (stack.m_41720_() != this) {
            return;
        }
        if (!this.isTeamRebindable(player.m_9236_(), player, stack) && stack.m_41782_() && stack.m_41783_().m_128425_(TEAM_TAG_KEY, 10)) {
            return;
        }
        stack.m_41784_().m_128365_(TEAM_TAG_KEY, (Tag)ITeam.write(team));
    }
}

