/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.badge;

import com.petrolpark.badge.Badge;
import com.petrolpark.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public class BadgesCapability {
    private final Set<Pair<Badge, Date>> badges = new HashSet<Pair<Badge, Date>>();

    public Collection<Pair<Badge, Date>> getBadges() {
        return Collections.unmodifiableSet(this.badges);
    }

    public void setBadges(Collection<Pair<Badge, Date>> badges) {
        this.badges.clear();
        this.badges.addAll(badges);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final Capability<BadgesCapability> PLAYER_BADGES = CapabilityManager.get((CapabilityToken)new CapabilityToken<BadgesCapability>(){});
        private BadgesCapability playerBadges = null;
        private final LazyOptional<BadgesCapability> optional = LazyOptional.of(this::createPlayerBadges);

        private BadgesCapability createPlayerBadges() {
            if (this.playerBadges == null) {
                this.playerBadges = new BadgesCapability();
            }
            return this.playerBadges;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag listTag = new ListTag();
            for (Pair<Badge, Date> pair : this.createPlayerBadges().badges) {
                CompoundTag badgeTag = new CompoundTag();
                ResourceLocation id = pair.getFirst().getId();
                if (id == null) continue;
                badgeTag.m_128359_("Id", id.toString());
                badgeTag.m_128356_("DateAwarded", pair.getSecond().getTime());
                listTag.add((Object)badgeTag);
            }
            tag.m_128365_("Badges", (Tag)listTag);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            ArrayList<Pair<Badge, Date>> badges = new ArrayList<Pair<Badge, Date>>();
            tag.m_128437_("Badges", 10).forEach(t -> {
                CompoundTag badgeTag = (CompoundTag)t;
                Badge badge = Badge.getBadge(ResourceLocation.m_135822_((String)badgeTag.m_128461_("Id"), (char)':'));
                if (badge == null) {
                    return;
                }
                badges.add(Pair.of(badge, new Date(badgeTag.m_128454_("DateAwarded"))));
            });
            this.createPlayerBadges().setBadges(badges);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == PLAYER_BADGES) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

