/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.petrolpark.Petrolpark;
import com.petrolpark.client.rendering.IGuiTexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum PetrolparkGuiTexture implements IGuiTexture
{
    JEI_POINTING_HAND("jei/widgets", 40, 40, 18, 14),
    JEI_SHORT_DOWN_ARROW("jei/widgets", 0, 64, 18, 18),
    JEI_SHORT_RIGHT_ARROW("jei/widgets", 0, 82, 18, 16),
    JEI_EQUILIBRIUM_ARROW("jei/widgets", 0, 96, 42, 11),
    JEI_LINE("jei/widgets", 40, 38, 177, 2),
    JEI_TEXT_BOX_LONG("jei/widgets", 169, 19),
    JEI_TEXT_BOX_SHORT("jei/widgets", 0, 19, 115, 19),
    JEI_DISTILLATION_TOWER_BOTTOM("jei/widgets", 0, 52, 12, 12),
    JEI_DISTILLATION_TOWER_MIDDLE("jei/widgets", 0, 40, 20, 12),
    JEI_DISTILLATION_TOWER_TOP("jei/widgets", 0, 38, 12, 2),
    JEI_DISTILLATION_TOWER_BRANCH("jei/widgets", 20, 45, 20, 2),
    JEI_EXPLOSION("jei/widgets", 169, 0, 18, 21),
    JEI_NERD_EMOJI("jei/widgets", 115, 19, 16, 14),
    JEI_GLOBE("jei/widgets", 131, 19, 16, 14),
    CREATIVE_MODE_TAB_BLANK_ROW("creative_inventory", 0, 0, 162, 18);

    public final ResourceLocation location;
    public final int width;
    public final int height;
    public final int startX;
    public final int startY;
    public final int textureWidth;
    public final int textureHeight;

    private PetrolparkGuiTexture(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private PetrolparkGuiTexture(String location, int startX, int startY, int width, int height) {
        this(location, startX, startY, width, height, 256, 256);
    }

    private PetrolparkGuiTexture(String location, int startX, int startY, int width, int height, int textureWidth, int textureHeight) {
        this.location = Petrolpark.asResource("textures/gui/" + location + ".png");
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.m_280163_(this.location, x, y, (float)this.startX, (float)this.startY, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getStartY() {
        return this.startY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }
}

