/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.shop;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.shop.Shop;
import com.petrolpark.shop.TeamShopsData;
import com.petrolpark.shop.customer.EntityCustomer;
import com.petrolpark.team.ITeam;
import com.petrolpark.team.ITeamBoundItem;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.team.data.TeamDataTypes;
import com.petrolpark.util.NBTHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShopMenuItem
extends Item
implements ITeamBoundItem<Item> {
    public static final String SHOP_TAG_KEY = "Shop";

    public ShopMenuItem(Item.Properties properties) {
        super(properties);
    }

    public Optional<Shop> getShop(Level level, Player player, ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128425_(SHOP_TAG_KEY, 8)) {
            return Optional.empty();
        }
        return Optional.ofNullable(NBTHelper.readRegistryObject(stack.m_41783_(), SHOP_TAG_KEY, PetrolparkRegistries.Keys.SHOP, level));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack stack = player.m_21120_(hand);
        if (this.getShop(level, player, stack).isPresent() && (result = this.trySelectTeam(stack, player, level)) != InteractionResult.PASS) {
            return new InteractionResultHolder(result, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        return this.getShop(player.m_9236_(), player, stack).filter(shop -> shop.canServe((Entity)entity)).map(shop -> {
            entity.getCapability(EntityCustomer.CAPABILITY);
            return InteractionResult.SUCCESS;
        }).orElse(super.m_6880_(stack, player, entity, hand));
    }

    @Override
    public boolean isTeamRebindable(Level level, Player player, ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Minecraft mc = Minecraft.m_91087_();
        this.getShop(level, (Player)mc.f_91074_, stack).ifPresent(shop -> {
            ITeam<?> team = ITeamBoundItem.getTeam(stack, level);
            if (!team.isNone()) {
                tooltipComponents.add((Component)((TeamShopsData)team.getTeamData((ITeamDataType)TeamDataTypes.SHOPS.get())).getName((Shop)shop).m_6881_().m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getTeamSelectionScreenTitle(Level level, Player player, ItemStack stack) {
        return Component.m_237110_((String)"item.petrolpark.menu.team_selection", (Object[])new Object[]{this.getShop(level, player, stack).map(Shop::getName).orElse((Component)Component.m_237115_((String)"shop.petrolpark.unknown"))});
    }
}

