/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayHelper {
    public static HitResult getHitResult(Entity entity, float partialTicks, boolean hitFluids) {
        return RayHelper.getHitResult(Collections.emptyList(), entity, partialTicks, hitFluids);
    }

    public static HitResult getHitResult(List<AABB> customBoxes, Entity entity, float partialTicks, boolean hitFluids) {
        AABB aabb;
        Vec3 view;
        Vec3 ray;
        EntityHitResult entityHitResult;
        double squareReach;
        double blockHitReach = RayHelper.getBlockReach(entity);
        double entityHitReach = RayHelper.getEntityReach(entity);
        double reach = Math.max(blockHitReach, entityHitReach);
        HitResult result = entity.m_19907_(reach, partialTicks, hitFluids);
        Vec3 eyePos = entity.m_146892_();
        double squareHitDistance = squareReach = reach * reach;
        if (result != null && result.m_6662_() != HitResult.Type.MISS) {
            Vec3 blockHitLocation = result.m_82450_();
            squareReach = blockHitLocation.m_82557_(eyePos);
            if (squareReach > blockHitReach * blockHitReach) {
                result = BlockHitResult.m_82426_((Vec3)blockHitLocation, (Direction)Direction.m_122366_((double)eyePos.f_82479_, (double)eyePos.f_82480_, (double)eyePos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)blockHitLocation));
            } else {
                squareHitDistance = squareReach;
            }
        }
        if ((entityHitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePos, (Vec3)(ray = eyePos.m_82549_((view = entity.m_20252_(partialTicks)).m_82490_(reach))), (AABB)(aabb = entity.m_20191_().m_82369_(view.m_82490_(reach)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_() && e.m_6087_(), (double)squareReach)) != null) {
            Vec3 entityHitLocation = entityHitResult.m_82450_();
            double squareEntityDistance = eyePos.m_82557_(entityHitLocation);
            if (squareEntityDistance > squareReach || squareEntityDistance > entityHitReach * entityHitReach) {
                result = BlockHitResult.m_82426_((Vec3)entityHitLocation, (Direction)Direction.m_122366_((double)view.f_82479_, (double)view.f_82480_, (double)view.f_82481_), (BlockPos)BlockPos.m_274446_((Position)entityHitLocation));
            } else if (squareEntityDistance < squareReach || result == null) {
                result = entityHitResult;
                squareHitDistance = squareEntityDistance;
            }
        }
        int i = 0;
        for (AABB box : customBoxes) {
            Vec3 customBoxHitLocation;
            double customBoxDistanceSquare;
            Optional hit = box.m_82371_(eyePos, ray);
            if (hit.isPresent() && (customBoxDistanceSquare = eyePos.m_82557_(customBoxHitLocation = (Vec3)hit.get())) < squareHitDistance) {
                result = new CustomHitResult(customBoxHitLocation, i);
                squareHitDistance = customBoxDistanceSquare;
            }
            ++i;
        }
        return result;
    }

    public static double getBlockReach(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getBlockReach();
        }
        return 3.0;
    }

    public static double getEntityReach(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getEntityReach();
        }
        return 3.0;
    }

    public static int getHit(List<AABB> boxes, Vec3 start, Vec3 end) {
        int hit = -1;
        int boxNo = 0;
        double minimumDistance = Double.MAX_VALUE;
        for (AABB box : boxes) {
            double distance;
            if (box.m_82390_(start)) {
                return boxNo;
            }
            Optional hitVec = box.m_82371_(start, end);
            if (hitVec.isPresent() && (distance = start.m_82557_((Vec3)hitVec.get())) < minimumDistance) {
                hit = boxNo;
                minimumDistance = distance;
            }
            ++boxNo;
        }
        return hit;
    }

    public static class CustomHitResult
    extends HitResult {
        public final int index;

        protected CustomHitResult(Vec3 location, int index) {
            super(location);
            this.index = index;
        }

        public HitResult.Type m_6662_() {
            return HitResult.Type.ENTITY;
        }
    }
}

