package com.petrolpark.core.recipe;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRecipeTypesOld;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface IPetrolparkRecipeTypes {

    @SuppressWarnings("deprecation")
    public static void register(IEventBus modEventBus) {
        PetrolparkRecipeTypesOld.register();
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    };

    public ResourceLocation getId();

    public <S extends RecipeSerializer<?>> S getSerializer();

    public <I extends RecipeInput, R extends Recipe<I>> RecipeType<R> getType();

    public default boolean is(Recipe<?> recipe) {
        return recipe.getType() == this.getType();
    };
    
    public static class Registers {
        public static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create(BuiltInRegistries.RECIPE_SERIALIZER, Petrolpark.MOD_ID);
        public static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create(BuiltInRegistries.RECIPE_TYPE, Petrolpark.MOD_ID);
    };
};
