package com.petrolpark.core.recipe.compression;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import org.apache.commons.lang3.math.Fraction;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class NoItemCompressionSequence implements IItemCompressionSequence {
    
    protected final ItemStack stack;
    protected final Optional<CompressedBlock> baseBlock;

    /**
     * @param stack Count is ignored
     */
    public NoItemCompressionSequence(ItemStack stack) {
        this.stack = stack.copyWithCount(1);
        baseBlock = stack.getItem() instanceof BlockItem blockItem ? Optional.of(new CompressedBlock(blockItem.getBlock(), this.stack)) : Optional.empty();
    };

    @Override
    public ItemStack getBaseItem() {
        return stack.copy();
    };

    @Override
    public List<ItemStack> getAllItems() {
        return Collections.singletonList(stack.copy());
    };

    @Override
    public int size() {
        return 1;
    };

    @Override
    public List<IItemCompression> getAllCompressions() {
        return Collections.emptyList();
    };

    @Override
    public Fraction getEquivalentBaseItems(ItemStack stack) {
        return ItemStack.isSameItemSameComponents(stack, this.stack) ? Fraction.getFraction(stack.getCount(), 1) : null;
    };

    @Override
    public double getEquivalentBaseItems(ItemStack stack, double count) {
        return ItemStack.isSameItemSameComponents(stack, this.stack) ? count : 0d;
    };

    @Override
    public Optional<CompressedBlock> getBaseBlock() {
        return baseBlock;
    };
};
