/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.sprite;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.Petrolpark;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public class SmallBannerSpriteSource
implements SpriteSource {
    public static final MapCodec<SmallBannerSpriteSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("source").forGetter(source -> source.sourcePath), (App)Codec.STRING.fieldOf("prefix").forGetter(source -> source.prefix)).apply((Applicative)instance, SmallBannerSpriteSource::new));
    public static final SpriteSourceType TYPE = new SpriteSourceType(CODEC);
    private final String sourcePath;
    private final String prefix;
    private final FileToIdConverter directoryFileToIdConverter;
    protected static final double BANNER_FRONT_HEIGHT = 0.625;
    protected static final double BANNER_FRONT_HALF_HEIGHT = 0.3125;
    protected static final double BANNER_FRONT_WIDTH = 0.34375;
    protected static final double SMALL_BANNER_HEIGHT = 0.34375;

    public SmallBannerSpriteSource(String sourcePath, String prefix) {
        this.sourcePath = sourcePath;
        this.prefix = prefix;
        this.directoryFileToIdConverter = new FileToIdConverter("textures/" + this.sourcePath, ".png");
    }

    public void run(@Nonnull ResourceManager resourceManager, @Nonnull SpriteSource.Output output) {
        this.directoryFileToIdConverter.listMatchingResources(resourceManager).forEach((location, resource) -> {
            ResourceLocation id = this.directoryFileToIdConverter.fileToId(location).withPrefix(this.prefix);
            try {
                Splicer splicer = resource.metadata().getSection(MetadataSection.TYPE).map(MetadataSection::splicer).orElse(Splicer.TOP_AND_BOTTOM);
                LazyLoadedImage image = new LazyLoadedImage(location, resource, 1);
                output.add(id, splicer.createSpriteSource(id, image));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public SpriteSourceType type() {
        return TYPE;
    }

    protected record MetadataSection(Splicer splicer) {
        public static final Codec<MetadataSection> CODEC = CodecHelper.singleField(Splicer.CODEC, "splicer", MetadataSection::splicer, MetadataSection::new);
        public static final String SECTION_NAME = Petrolpark.asResource("banner_splicer").toString();
        public static final MetadataSectionType<MetadataSection> TYPE = MetadataSectionType.fromCodec((String)SECTION_NAME, CODEC);
    }

    public static enum Splicer implements StringRepresentable
    {
        TOP_AND_BOTTOM{

            @Override
            public SpriteSource.SpriteSupplier createSpriteSource(ResourceLocation id, LazyLoadedImage image) {
                return new TopAndBottom(id, image);
            }
        }
        ,
        SQUEEZE{

            @Override
            public SpriteSource.SpriteSupplier createSpriteSource(ResourceLocation id, LazyLoadedImage image) {
                return new Squeeze(id, image);
            }
        };

        public static final Codec<Splicer> CODEC;

        public String getSerializedName() {
            return Lang.asId(this.name());
        }

        public abstract SpriteSource.SpriteSupplier createSpriteSource(ResourceLocation var1, LazyLoadedImage var2);

        static {
            CODEC = StringRepresentable.fromEnum(Splicer::values);
        }
    }

    protected record Squeeze(ResourceLocation id, LazyLoadedImage image) implements SpriteSource.SpriteSupplier
    {
        public SpriteContents apply(SpriteResourceLoader resourceLoader) {
            try {
                NativeImage nativeImage = this.image().get();
            }
            catch (Exception exception) {
            }
            finally {
                this.image().release();
            }
            return MissingTextureAtlasSprite.create();
        }
    }

    protected record TopAndBottom(ResourceLocation id, LazyLoadedImage image) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader resourceLoader) {
            try {
                int x;
                int topHalfTop;
                NativeImage bigImage = this.image().get();
                int halfwayDown = Mth.floor((double)(0.3125 * (double)bigImage.getHeight()));
                int bottom = Mth.floor((double)(0.625 * (double)bigImage.getHeight()));
                int right = Mth.floor((double)(0.34375 * (double)bigImage.getWidth()));
                int smallBannerHeight = Mth.floor((double)(0.34375 * (double)bigImage.getHeight()));
                int bottomHalfBottom = bottom;
                block5: for (topHalfTop = 0; topHalfTop < halfwayDown; ++topHalfTop) {
                    for (x = 0; x < right; ++x) {
                        if (bigImage.getLuminanceOrAlpha(x, topHalfTop) != 0) break block5;
                    }
                }
                block7: while (bottomHalfBottom > halfwayDown + 1) {
                    for (x = 0; x < right; ++x) {
                        if (bigImage.getLuminanceOrAlpha(x, bottomHalfBottom) != 0) break block7;
                    }
                    --bottomHalfBottom;
                }
                NativeImage smallImage = new NativeImage(NativeImage.Format.RGBA, bigImage.getWidth() / 2, bigImage.getHeight() / 2, false);
                if (bottomHalfBottom - topHalfTop <= smallBannerHeight) {
                    if (topHalfTop == 0) {
                        bottomHalfBottom = smallBannerHeight;
                    } else if (bottomHalfBottom == bottom) {
                        topHalfTop = bottom - smallBannerHeight;
                    } else {
                        int padding = smallBannerHeight - bottomHalfBottom + topHalfTop;
                        int topPadding = padding / 2;
                        if (topPadding > topHalfTop) {
                            topPadding = topHalfTop;
                        } else if (padding - topPadding > bottom - bottomHalfBottom) {
                            topPadding = padding - bottom + bottomHalfBottom;
                        }
                        topHalfTop -= topPadding;
                        bottomHalfBottom += padding - topPadding;
                    }
                    bigImage.copyRect(smallImage, 0, topHalfTop, 0, 0, right, bottomHalfBottom - topHalfTop, false, false);
                } else {
                    int smallBannerTopHalfHeight = smallBannerHeight / 2;
                    bigImage.copyRect(smallImage, 0, topHalfTop, 0, 0, right, topHalfTop + smallBannerTopHalfHeight, false, false);
                    bigImage.copyRect(smallImage, 0, bottomHalfBottom + 1 - smallBannerHeight + smallBannerTopHalfHeight, 0, smallBannerTopHalfHeight, right, smallBannerHeight - smallBannerTopHalfHeight, false, false);
                }
                SpriteContents spriteContents = new SpriteContents(this.id(), new FrameSize(smallImage.getWidth(), smallImage.getHeight()), smallImage, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (Exception exception) {
                Petrolpark.LOGGER.error("Failed to generate small Banner Pattern {}", (Object)this.id(), (Object)exception);
            }
            finally {
                this.image().release();
            }
            return MissingTextureAtlasSprite.create();
        }
    }
}

