/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.common.item.shulkerbelt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkItems;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ShulkerBeltLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ModelResourceLocation SHULKER_BELT = ModelResourceLocation.standalone((ResourceLocation)Petrolpark.asResource("item/shulker_belt_on_body"));
    public static final List<Predicate<LivingEntity>> WEARING_PREDICATES = new ArrayList<Predicate<LivingEntity>>();
    protected final ItemRenderer itemRenderer;
    protected final ItemStack beltStackInstance;

    public ShulkerBeltLayer(RenderLayerParent<T, M> renderer, ItemRenderer itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
        this.beltStackInstance = PetrolparkItems.SHULKER_BELT.asStack();
    }

    public void render(@Nonnull PoseStack ms, @Nonnull MultiBufferSource bufferSource, int packedLight, @Nonnull T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (WEARING_PREDICATES.stream().noneMatch(p -> p.test(livingEntity))) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        ms.pushPose();
        model.body.translateAndRotate(ms);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateZDegrees(180.0f)).scale(1.2857143f)).translate(0.28125f, 0.03125f, 0.375f);
        this.itemRenderer.render(this.beltStackInstance, ItemDisplayContext.NONE, false, ms, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, this.itemRenderer.getItemModelShaper().getModelManager().getModel(SHULKER_BELT));
        ms.popPose();
    }

    public static void registerOn(EntityRenderer<?> entityRenderer, ItemRenderer itemRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        ShulkerBeltLayer layer = new ShulkerBeltLayer(livingRenderer, itemRenderer);
        livingRenderer.addLayer(layer);
    }

    @SubscribeEvent
    public static final void onRegisterLayerDefintions(EntityRenderersEvent.AddLayers event) {
        ItemRenderer itemRenderer = event.getContext().getItemRenderer();
        EntityRenderDispatcher renderManager = event.getContext().getEntityRenderDispatcher();
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            ShulkerBeltLayer.registerOn(renderer, itemRenderer);
        }
        for (EntityRenderer renderer : renderManager.renderers.values()) {
            ShulkerBeltLayer.registerOn(renderer, itemRenderer);
        }
    }

    @SubscribeEvent
    public static final void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(SHULKER_BELT);
    }

    static {
        WEARING_PREDICATES.add(player -> PetrolparkItems.SHULKER_BELT.isIn(player.getItemBySlot(EquipmentSlot.LEGS)));
    }
}

