/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat;

import com.mojang.serialization.Codec;
import com.petrolpark.compat.Mods;
import com.petrolpark.util.Lang;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.ApiStatus;

public enum SharedFeatureFlag implements StringRepresentable
{
    CENTRIFUGE(new SharedFeatureFlag[0]),
    BASIN_LID(new SharedFeatureFlag[0]),
    TORQUE_LIMITER(new SharedFeatureFlag[0]),
    MESH(new SharedFeatureFlag[0]),
    EXTRUSION(MESH),
    SUNFLOWER_OIL(new SharedFeatureFlag[0]),
    MILK_PRODUCTS(CENTRIFUGE),
    SPRING(new SharedFeatureFlag[0]),
    POTATO_PRODUCTS(MILK_PRODUCTS, EXTRUSION),
    MANDREL(SPRING);

    public static final Codec<SharedFeatureFlag> CODEC;
    private final SharedFeatureFlag[] dependencies;
    private final SortedSet<Mods> users = new TreeSet<Mods>(Enum::compareTo);
    private boolean enabled = false;

    private SharedFeatureFlag(SharedFeatureFlag ... dependencies) {
        this.dependencies = dependencies;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enable(Mods mod) {
        this.enabled = true;
        this.users.add(mod);
        for (SharedFeatureFlag feature : this.dependencies) {
            feature.enable(mod);
        }
    }

    @ApiStatus.Internal
    public static void enableAll() {
        for (SharedFeatureFlag feature : SharedFeatureFlag.values()) {
            feature.enable(Mods.PETROLPARK);
        }
    }

    public String getSerializedName() {
        return Lang.asId(this.name());
    }

    public Stream<Mods> streamUsers() {
        return this.users.stream();
    }

    static {
        CODEC = StringRepresentable.fromEnum(SharedFeatureFlag::values);
    }
}

