/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.client.offgridtiling;

import com.petrolpark.compat.create.client.offgridtiling.OffGridTilingMetadataSection;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class OffGridTilingModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<BlockPos> POS_PROPERTY = new ModelProperty();

    public OffGridTilingModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        return builder.with(POS_PROPERTY, (Object)pos);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(POS_PROPERTY)) {
            return quads;
        }
        BlockPos pos = (BlockPos)extraData.get(POS_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            TextureAtlasSprite sprite = quad.getSprite();
            Optional sectionOp = sprite.contents().metadata().getSection(OffGridTilingMetadataSection.TYPE);
            if (sectionOp.isEmpty()) continue;
            OffGridTilingMetadataSection section = (OffGridTilingMetadataSection)sectionOp.get();
            Direction face = quad.getDirection();
            float uShift = (float)OffGridTilingModel.getHorizontalPosition(pos, face) % section.xSize() / section.scale();
            float vShift = (float)OffGridTilingModel.getVerticalPosition(pos, face) % section.ySize() / section.scale();
            BakedQuad newQuad = BakedQuadHelper.clone((BakedQuad)quad);
            int[] vertexData = newQuad.getVertices();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU((int[])vertexData, (int)vertex);
                float v = BakedQuadHelper.getV((int[])vertexData, (int)vertex);
                BakedQuadHelper.setU((int[])vertexData, (int)vertex, (float)sprite.getU(SpriteShiftEntry.getUnInterpolatedU((TextureAtlasSprite)sprite, (float)u) + uShift));
                BakedQuadHelper.setV((int[])vertexData, (int)vertex, (float)sprite.getV(SpriteShiftEntry.getUnInterpolatedV((TextureAtlasSprite)sprite, (float)v) + vShift));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    protected static int getVerticalPosition(@Nonnull BlockPos pos, @Nonnull Direction face) {
        return face.getAxis().isHorizontal() ? -pos.getY() : pos.getZ();
    }

    protected static int getHorizontalPosition(@Nonnull BlockPos pos, @Nonnull Direction face) {
        return face.getAxis() == Direction.Axis.X ? pos.getZ() : pos.getX();
    }
}

